<?php
/**
 * Plugin Name: Final Checkout Security
 * Description: Perfect PIN and OTP verification flow.
 * Version: 1.5
 * Author: Your Name
 */

if (!defined('ABSPATH')) exit;

// Start session
if (!session_id()) {
    session_start();
}

// Admin Menu
add_action('admin_menu', 'csv_add_admin_menu');
function csv_add_admin_menu() {
    add_menu_page(
        'Checkout Security', 
        'Checkout Security', 
        'manage_options', 
        'checkout-security', 
        'csv_settings_page',
        'dashicons-lock'
    );
}

// Admin Settings
function csv_settings_page() {
    if (isset($_POST['csv_save_settings'])) {
        update_option('csv_enable_pin', isset($_POST['csv_enable_pin']) ? 1 : 0);
        update_option('csv_enable_otp', isset($_POST['csv_enable_otp']) ? 1 : 0);
        update_option('csv_pin_code', sanitize_text_field($_POST['csv_pin_code']));
        update_option('csv_otp_expiry', absint($_POST['csv_otp_expiry']));
        
        // Reset verification
        unset($_SESSION['pin_verified']);
        unset($_SESSION['otp_verified']);
        
        echo '<div class="updated"><p>Settings saved.</p></div>';
    }
    
    $current_pin = get_option('csv_pin_code', '1642');
    ?>
    <div class="wrap">
        <h1>Checkout Security Settings</h1>
        <form method="POST" style="max-width: 600px;">
            <table class="form-table">
                <tr>
                    <th scope="row"><label>Enable PIN Verification</label></th>
                    <td><input type="checkbox" name="csv_enable_pin" value="1" <?php checked(get_option('csv_enable_pin', 1)); ?>></td>
                </tr>
                <tr>
                    <th scope="row"><label>PIN Code</label></th>
                    <td><input type="text" name="csv_pin_code" value="<?php echo esc_attr($current_pin); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th scope="row"><label>Enable OTP Verification</label></th>
                    <td><input type="checkbox" name="csv_enable_otp" value="1" <?php checked(get_option('csv_enable_otp', 1)); ?>></td>
                </tr>
                <tr>
                    <th scope="row"><label>OTP Expiry (minutes)</label></th>
                    <td><input type="number" name="csv_otp_expiry" value="<?php echo absint(get_option('csv_otp_expiry', 15)); ?>" min="1" class="small-text"></td>
                </tr>
            </table>
            <?php submit_button('Save Settings'); ?>
        </form>
    </div>
    <?php
}

// Cart Redirect
add_filter('woocommerce_add_to_cart_redirect', 'csv_redirect_to_checkout');
function csv_redirect_to_checkout($url) {
    return wc_get_checkout_url();
}

// Change Add to Cart text
add_filter('woocommerce_product_single_add_to_cart_text', 'csv_custom_add_to_cart_text');
add_filter('woocommerce_product_add_to_cart_text', 'csv_custom_add_to_cart_text');
function csv_custom_add_to_cart_text() {
    return 'Proceed';
}

// Verification Flow - FIXED VERSION
add_action('template_redirect', 'csv_protect_checkout');
function csv_protect_checkout() {
    if (!is_checkout() || is_wc_endpoint_url('order-received') || is_wc_endpoint_url('order-pay')) {
        return;
    }

    // Reset verification for each checkout attempt
    if (!isset($_SESSION['verification_started'])) {
        unset($_SESSION['pin_verified']);
        unset($_SESSION['otp_verified']);
        unset($_SESSION['otp']);
        $_SESSION['verification_started'] = true;
    }

    $pin = get_option('csv_pin_code', '1642');
    $otp_expiry = get_option('csv_otp_expiry', 15) * 60;

    // PIN Verification
    if (get_option('csv_enable_pin', 1) && !isset($_SESSION['pin_verified'])) {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['page_password'])) {
            if ($_POST['page_password'] === $pin) {
                $_SESSION['pin_verified'] = true;
                
                if (get_option('csv_enable_otp', 1)) {
                    if (csv_generate_and_send_otp()) {
                        // Force reload to show OTP form
                        wp_redirect(wc_get_checkout_url());
                        exit;
                    } else {
                        csv_show_pin_form('Failed to send OTP. Please try again.');
                        exit;
                    }
                }
            } else {
                csv_show_pin_form('Invalid PIN. Please try again.');
                exit;
            }
        }
        
        // Show PIN form if not submitted or if OTP not enabled
        if (!isset($_SESSION['pin_verified']) || !get_option('csv_enable_otp', 1)) {
            csv_show_pin_form();
            exit;
        }
    }

    // OTP Verification
    if (get_option('csv_enable_otp', 1) && isset($_SESSION['pin_verified']) && !isset($_SESSION['otp_verified'])) {
        // Check for expired OTP
        if (isset($_SESSION['otp_time']) && (time() - $_SESSION['otp_time'] > $otp_expiry)) {
            unset($_SESSION['otp']);
        }
        
        // Handle form submissions
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            if (isset($_POST['resend_otp'])) {
                if (csv_generate_and_send_otp()) {
                    csv_show_otp_form('New OTP sent successfully!');
                    exit;
                } else {
                    csv_show_otp_form('Failed to resend OTP. Please try again.');
                    exit;
                }
            } elseif (isset($_POST['otp_code'])) {
                if (isset($_SESSION['otp']) && $_POST['otp_code'] == $_SESSION['otp']) {
                    $_SESSION['otp_verified'] = true;
                    unset($_SESSION['verification_started']);
                    return; // Allow checkout to proceed
                } else {
                    csv_show_otp_form('Invalid OTP. Please try again.');
                    exit;
                }
            }
        }
        
        // Show OTP form if we have an OTP or need to generate one
        if (!isset($_SESSION['otp'])) {
            if (csv_generate_and_send_otp()) {
                csv_show_otp_form();
                exit;
            } else {
                csv_show_pin_form('Failed to send OTP. Please try again.');
                exit;
            }
        } else {
            csv_show_otp_form();
            exit;
        }
    }
}

// OTP Email Function
function csv_generate_and_send_otp() {
    if (!is_user_logged_in()) return false;
    
    $_SESSION['otp'] = str_pad(mt_rand(0, 999999), 6, '0', STR_PAD_LEFT);
    $_SESSION['otp_time'] = time();
    
    $user = wp_get_current_user();
    $user_email = $user->user_email;
    if (empty($user_email)) return false;

    $subject = 'Your IMF Verification Code';
    $message = '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; text-align: center;">
        <h2 style="color: #333;">Your IMF Verification Code</h2>
        <div style="background: #f5f5f5; padding: 20px; border-radius: 5px; margin: 20px 0;">
            <div style="font-size: 24px; font-weight: bold; letter-spacing: 3px;">' . $_SESSION['otp'] . '</div>
        </div>
        <p style="color: #555;">This code will expire in ' . get_option('csv_otp_expiry', 15) . ' minutes.</p>
    </div>';

    $headers = [
        'Content-Type: text/html; charset=UTF-8',
        'From: ' . get_bloginfo('name') . ' <' . get_option('admin_email') . '>'
    ];
    
    return wp_mail($user_email, $subject, $message, $headers);
}

// PIN Form (Improved Design)
function csv_show_pin_form($error = '') {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Verify Security PIN</title>
        <style>
            body { font-family: Arial, sans-serif; background: #f8f9fa; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
            .security-container { background: white; border-radius: 8px; box-shadow: 0 2px 20px rgba(0,0,0,0.1); width: 100%; max-width: 400px; padding: 30px; text-align: center; }
            h2 { color: #2c3e50; margin-top: 0; margin-bottom: 20px; }
            input { width: 100%; padding: 12px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 4px; font-size: 16px; box-sizing: border-box; }
            button { width: 100%; padding: 12px; background: #3498db; color: white; border: none; border-radius: 4px; font-size: 16px; cursor: pointer; transition: background 0.3s; }
            button:hover { background: #2980b9; }
            .error-message { color: #e74c3c; margin: 15px 0; }
        </style>
    </head>
    <body>
        <div class="security-container">
            <h2>Verify Security PIN</h2>
            <?php if ($error): ?>
                <div class="error-message"><?php echo esc_html($error); ?></div>
            <?php endif; ?>
            <form method="POST">
                <input type="password" name="page_password" placeholder="Enter PIN" required>
                <button type="submit">Continue</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// OTP Form (Improved Design with Resend)
function csv_show_otp_form($message = '') {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Verify IMF Code</title>
        <style>
            body { font-family: Arial, sans-serif; background: #f8f9fa; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
            .security-container { background: white; border-radius: 8px; box-shadow: 0 2px 20px rgba(0,0,0,0.1); width: 100%; max-width: 400px; padding: 30px; text-align: center; }
            h2 { color: #2c3e50; margin-top: 0; margin-bottom: 20px; }
            .info-message { color: #3498db; margin: 15px 0; }
            .error-message { color: #e74c3c; margin: 15px 0; }
            input { width: 100%; padding: 12px; margin-bottom: 15px; border: 1px solid #ddd; border-radius: 4px; font-size: 16px; box-sizing: border-box; }
            button { width: 100%; padding: 12px; background: #3498db; color: white; border: none; border-radius: 4px; font-size: 16px; cursor: pointer; }
            button:hover { background: #2980b9; }
            .resend-btn { background: #95a5a6; margin-top: 10px; }
            .resend-btn:hover { background: #7f8c8d; }
            .support-info { margin-top: 25px; padding-top: 15px; border-top: 1px solid #eee; font-size: 14px; color: #7f8c8d; }
        </style>
    </head>
    <body>
        <div class="security-container">
            <h2>Verify IMF Code</h2>
            
            <?php if ($message): ?>
                <div class="<?php echo strpos($message, 'Failed') !== false ? 'error-message' : 'info-message'; ?>">
                    <?php echo esc_html($message); ?>
                </div>
            <?php endif; ?>
            
            <p>Please check your email for the verification code.</p>
            
            <form method="POST">
                <input type="text" name="otp_code" placeholder="Enter 6-digit OTP" required>
                <button type="submit">Verify Code</button>
            </form>
            
            <form method="POST">
                <button type="submit" name="resend_otp" class="resend-btn">Resend OTP</button>
            </form>
            
            <div class="support-info">
                <p><strong>The IMF code is required to help you proceed with this transaction.</strong></p>
                <p>Please contact support via live chat, send an email to support@unitedcountycu.com, or visit our nearest branch for assistance.</p>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit;
}