jQuery(document).ready(function() {
  
    const ueProtectedContent = jQuery("#{{uc_id}}"); // Unique identifier for elements
    const ueActivePass = new Set([ {% if protection_type == "single_pass" %}"{{single_password|raw}}"{% elseif protection_type == "multipass" %}{{multi_passwords|raw}}{% endif %} ]);
    var   uePC_CookieName = `{{cookie_name}}_{{uc_id}}`;
    var   cookieValue = "access_allowed";

    {# Start - Calculate cookie expiration time - this calculation allows to set time in days, hours and minutes #}
    {% set days = cookie_expiration_days | default(0) %}
    {% set hours = cookie_expiration_hours | default(0) %}
    {% set minutes = cookie_expiration_minutes | default(0) %}
    {% set expiration_time = (days * 24 * 60 * 60 * 1000) + (hours * 60 * 60 * 1000) + (minutes * 60 * 1000) %}
    {# End - Calculate cookie expiration time #}
  
    var cookieExpirationTime = {{expiration_time}};
  
    {% if (uc_inside_editor != "yes") and (design_debug != "protected_only" or design_debug != "both") %}
      // Check for existing cookie to unlock content if it exists
      if (ueGetCookie(uePC_CookieName) === "access_allowed") {
        showUnlockedContent();
      }
    {% endif %}
    
    // Event listener for submit button
    ueProtectedContent.find(`#{{uc_id}}_submit_button`).click(function() {
      const ueUserEnteredPass = ueProtectedContent.find(`#{{uc_id}}_password_input`).val();
      
      {% if hash_sha_256_password == "true" %} hashPassword(ueUserEnteredPass).then((ueUserEnteredPass) => { {% endif %}
        if (ueActivePass.has(ueUserEnteredPass)){
          ueSetCookie(uePC_CookieName, cookieValue, cookieExpirationTime); 
          showUnlockedContent();
        } else {
          ueProtectedContent.find(`.ue_pc_error_message`).show();
        }
      {% if hash_sha_256_password == "true" %} }); {% endif %}      
      
    });
    
  // function to hash user input password                                                                                        
  {% if hash_sha_256_password == "true" %}
    function hashPassword(password) {
      const encoder = new TextEncoder();
      const data = encoder.encode(password);
      return crypto.subtle.digest("SHA-256", data).then((hashBuffer) => {
        // Convert ArrayBuffer to Hex string
        let hashArray = Array.from(new Uint8Array(hashBuffer));
        let hashHex = hashArray.map(byte => byte.toString(16).padStart(2, '0')).join('');
        return hashHex;
      });
    }
  {% endif %}
  
    // Function to display unlocked content and hide locked content
    function showUnlockedContent() {
      ueProtectedContent.find(`.ue_locked_content`).hide();
      ueProtectedContent.find(`.ue_unlocked_content`).show();
    }

    // Cookie handling functions
    function ueSetCookie(name, value, expirationTime) {
      const d = new Date();
      d.setTime(d.getTime() + expirationTime);
      document.cookie = `${name}=${value};expires=${d.toUTCString()};path=/`;
    }

    function ueGetCookie(name) {
      const nameEQ = name + "=";
      const ca = document.cookie.split(";");
      for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) === " ") c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
      }
      return null;
    }

});