jQuery(document).ready(function($) {
    var lastPurchasedProductId = customData.lastPurchasedProductId;

    if (lastPurchasedProductId) {
        // Hide all sections initially
        $('[class*="elementor-section-product-"]').hide();

        // Iterate over all sections with a class containing 'elementor-section-product-'
        $('[class*="elementor-section-product-"]').each(function() {
            var classes = $(this).attr('class').split(' ');
            var showSection = false;

            // Check each class to see if it contains the last purchased product ID
            $.each(classes, function(index, className) {
                if (className.indexOf('elementor-section-product-') !== -1) {
                    var productIds = className.replace('elementor-section-product-', '').split('-');
                    if (productIds.includes(lastPurchasedProductId.toString())) {
                        showSection = true;
                    }
                }
            });

            // Show the section if a matching product ID is found
            if (showSection) {
                $(this).show();
            }
        });
    }
});
