<?php

defined('ABSPATH') || exit;

return array(
    'AF' => array(),
    'AL' => array( // Albanian states.
        'AL-01' => __('Berat', 'wp-user-avatar'),
        'AL-09' => __('Dibër', 'wp-user-avatar'),
        'AL-02' => __('Durrës', 'wp-user-avatar'),
        'AL-03' => __('Elbasan', 'wp-user-avatar'),
        'AL-04' => __('Fier', 'wp-user-avatar'),
        'AL-05' => __('Gjirokastër', 'wp-user-avatar'),
        'AL-06' => __('Korçë', 'wp-user-avatar'),
        'AL-07' => __('Kukës', 'wp-user-avatar'),
        'AL-08' => __('Lezhë', 'wp-user-avatar'),
        'AL-10' => __('Shkodër', 'wp-user-avatar'),
        'AL-11' => __('Tirana', 'wp-user-avatar'),
        'AL-12' => __('Vlorë', 'wp-user-avatar'),
    ),
    'AO' => array( // Angolan states.
        'BGO' => __('Bengo', 'wp-user-avatar'),
        'BLU' => __('Benguela', 'wp-user-avatar'),
        'BIE' => __('Bié', 'wp-user-avatar'),
        'CAB' => __('Cabinda', 'wp-user-avatar'),
        'CNN' => __('Cunene', 'wp-user-avatar'),
        'HUA' => __('Huambo', 'wp-user-avatar'),
        'HUI' => __('Huíla', 'wp-user-avatar'),
        'CCU' => __('Kuando Kubango', 'wp-user-avatar'),
        'CNO' => __('Kwanza-Norte', 'wp-user-avatar'),
        'CUS' => __('Kwanza-Sul', 'wp-user-avatar'),
        'LUA' => __('Luanda', 'wp-user-avatar'),
        'LNO' => __('Lunda-Norte', 'wp-user-avatar'),
        'LSU' => __('Lunda-Sul', 'wp-user-avatar'),
        'MAL' => __('Malanje', 'wp-user-avatar'),
        'MOX' => __('Moxico', 'wp-user-avatar'),
        'NAM' => __('Namibe', 'wp-user-avatar'),
        'UIG' => __('Uíge', 'wp-user-avatar'),
        'ZAI' => __('Zaire', 'wp-user-avatar'),
    ),
    'AR' => array( // Argentinian provinces.
        'C' => __('Ciudad Autónoma de Buenos Aires', 'wp-user-avatar'),
        'B' => __('Buenos Aires', 'wp-user-avatar'),
        'K' => __('Catamarca', 'wp-user-avatar'),
        'H' => __('Chaco', 'wp-user-avatar'),
        'U' => __('Chubut', 'wp-user-avatar'),
        'X' => __('Córdoba', 'wp-user-avatar'),
        'W' => __('Corrientes', 'wp-user-avatar'),
        'E' => __('Entre Ríos', 'wp-user-avatar'),
        'P' => __('Formosa', 'wp-user-avatar'),
        'Y' => __('Jujuy', 'wp-user-avatar'),
        'L' => __('La Pampa', 'wp-user-avatar'),
        'F' => __('La Rioja', 'wp-user-avatar'),
        'M' => __('Mendoza', 'wp-user-avatar'),
        'N' => __('Misiones', 'wp-user-avatar'),
        'Q' => __('Neuquén', 'wp-user-avatar'),
        'R' => __('Río Negro', 'wp-user-avatar'),
        'A' => __('Salta', 'wp-user-avatar'),
        'J' => __('San Juan', 'wp-user-avatar'),
        'D' => __('San Luis', 'wp-user-avatar'),
        'Z' => __('Santa Cruz', 'wp-user-avatar'),
        'S' => __('Santa Fe', 'wp-user-avatar'),
        'G' => __('Santiago del Estero', 'wp-user-avatar'),
        'V' => __('Tierra del Fuego', 'wp-user-avatar'),
        'T' => __('Tucumán', 'wp-user-avatar'),
    ),
    'AT' => array(),
    'AU' => array( // Australian states.
        'ACT' => __('Australian Capital Territory', 'wp-user-avatar'),
        'NSW' => __('New South Wales', 'wp-user-avatar'),
        'NT'  => __('Northern Territory', 'wp-user-avatar'),
        'QLD' => __('Queensland', 'wp-user-avatar'),
        'SA'  => __('South Australia', 'wp-user-avatar'),
        'TAS' => __('Tasmania', 'wp-user-avatar'),
        'VIC' => __('Victoria', 'wp-user-avatar'),
        'WA'  => __('Western Australia', 'wp-user-avatar'),
    ),
    'AX' => array(),
    'BD' => array( // Bangladeshi districts.
        'BD-05' => __('Bagerhat', 'wp-user-avatar'),
        'BD-01' => __('Bandarban', 'wp-user-avatar'),
        'BD-02' => __('Barguna', 'wp-user-avatar'),
        'BD-06' => __('Barishal', 'wp-user-avatar'),
        'BD-07' => __('Bhola', 'wp-user-avatar'),
        'BD-03' => __('Bogura', 'wp-user-avatar'),
        'BD-04' => __('Brahmanbaria', 'wp-user-avatar'),
        'BD-09' => __('Chandpur', 'wp-user-avatar'),
        'BD-10' => __('Chattogram', 'wp-user-avatar'),
        'BD-12' => __('Chuadanga', 'wp-user-avatar'),
        'BD-11' => __("Cox's Bazar", 'wp-user-avatar'),
        'BD-08' => __('Cumilla', 'wp-user-avatar'),
        'BD-13' => __('Dhaka', 'wp-user-avatar'),
        'BD-14' => __('Dinajpur', 'wp-user-avatar'),
        'BD-15' => __('Faridpur ', 'wp-user-avatar'),
        'BD-16' => __('Feni', 'wp-user-avatar'),
        'BD-19' => __('Gaibandha', 'wp-user-avatar'),
        'BD-18' => __('Gazipur', 'wp-user-avatar'),
        'BD-17' => __('Gopalganj', 'wp-user-avatar'),
        'BD-20' => __('Habiganj', 'wp-user-avatar'),
        'BD-21' => __('Jamalpur', 'wp-user-avatar'),
        'BD-22' => __('Jashore', 'wp-user-avatar'),
        'BD-25' => __('Jhalokati', 'wp-user-avatar'),
        'BD-23' => __('Jhenaidah', 'wp-user-avatar'),
        'BD-24' => __('Joypurhat', 'wp-user-avatar'),
        'BD-29' => __('Khagrachhari', 'wp-user-avatar'),
        'BD-27' => __('Khulna', 'wp-user-avatar'),
        'BD-26' => __('Kishoreganj', 'wp-user-avatar'),
        'BD-28' => __('Kurigram', 'wp-user-avatar'),
        'BD-30' => __('Kushtia', 'wp-user-avatar'),
        'BD-31' => __('Lakshmipur', 'wp-user-avatar'),
        'BD-32' => __('Lalmonirhat', 'wp-user-avatar'),
        'BD-36' => __('Madaripur', 'wp-user-avatar'),
        'BD-37' => __('Magura', 'wp-user-avatar'),
        'BD-33' => __('Manikganj ', 'wp-user-avatar'),
        'BD-39' => __('Meherpur', 'wp-user-avatar'),
        'BD-38' => __('Moulvibazar', 'wp-user-avatar'),
        'BD-35' => __('Munshiganj', 'wp-user-avatar'),
        'BD-34' => __('Mymensingh', 'wp-user-avatar'),
        'BD-48' => __('Naogaon', 'wp-user-avatar'),
        'BD-43' => __('Narail', 'wp-user-avatar'),
        'BD-40' => __('Narayanganj', 'wp-user-avatar'),
        'BD-42' => __('Narsingdi', 'wp-user-avatar'),
        'BD-44' => __('Natore', 'wp-user-avatar'),
        'BD-45' => __('Nawabganj', 'wp-user-avatar'),
        'BD-41' => __('Netrakona', 'wp-user-avatar'),
        'BD-46' => __('Nilphamari', 'wp-user-avatar'),
        'BD-47' => __('Noakhali', 'wp-user-avatar'),
        'BD-49' => __('Pabna', 'wp-user-avatar'),
        'BD-52' => __('Panchagarh', 'wp-user-avatar'),
        'BD-51' => __('Patuakhali', 'wp-user-avatar'),
        'BD-50' => __('Pirojpur', 'wp-user-avatar'),
        'BD-53' => __('Rajbari', 'wp-user-avatar'),
        'BD-54' => __('Rajshahi', 'wp-user-avatar'),
        'BD-56' => __('Rangamati', 'wp-user-avatar'),
        'BD-55' => __('Rangpur', 'wp-user-avatar'),
        'BD-58' => __('Satkhira', 'wp-user-avatar'),
        'BD-62' => __('Shariatpur', 'wp-user-avatar'),
        'BD-57' => __('Sherpur', 'wp-user-avatar'),
        'BD-59' => __('Sirajganj', 'wp-user-avatar'),
        'BD-61' => __('Sunamganj', 'wp-user-avatar'),
        'BD-60' => __('Sylhet', 'wp-user-avatar'),
        'BD-63' => __('Tangail', 'wp-user-avatar'),
        'BD-64' => __('Thakurgaon', 'wp-user-avatar'),
    ),
    'BE' => array(),
    'BG' => array( // Bulgarian states.
        'BG-01' => __('Blagoevgrad', 'wp-user-avatar'),
        'BG-02' => __('Burgas', 'wp-user-avatar'),
        'BG-08' => __('Dobrich', 'wp-user-avatar'),
        'BG-07' => __('Gabrovo', 'wp-user-avatar'),
        'BG-26' => __('Haskovo', 'wp-user-avatar'),
        'BG-09' => __('Kardzhali', 'wp-user-avatar'),
        'BG-10' => __('Kyustendil', 'wp-user-avatar'),
        'BG-11' => __('Lovech', 'wp-user-avatar'),
        'BG-12' => __('Montana', 'wp-user-avatar'),
        'BG-13' => __('Pazardzhik', 'wp-user-avatar'),
        'BG-14' => __('Pernik', 'wp-user-avatar'),
        'BG-15' => __('Pleven', 'wp-user-avatar'),
        'BG-16' => __('Plovdiv', 'wp-user-avatar'),
        'BG-17' => __('Razgrad', 'wp-user-avatar'),
        'BG-18' => __('Ruse', 'wp-user-avatar'),
        'BG-27' => __('Shumen', 'wp-user-avatar'),
        'BG-19' => __('Silistra', 'wp-user-avatar'),
        'BG-20' => __('Sliven', 'wp-user-avatar'),
        'BG-21' => __('Smolyan', 'wp-user-avatar'),
        'BG-23' => __('Sofia District', 'wp-user-avatar'),
        'BG-22' => __('Sofia', 'wp-user-avatar'),
        'BG-24' => __('Stara Zagora', 'wp-user-avatar'),
        'BG-25' => __('Targovishte', 'wp-user-avatar'),
        'BG-03' => __('Varna', 'wp-user-avatar'),
        'BG-04' => __('Veliko Tarnovo', 'wp-user-avatar'),
        'BG-05' => __('Vidin', 'wp-user-avatar'),
        'BG-06' => __('Vratsa', 'wp-user-avatar'),
        'BG-28' => __('Yambol', 'wp-user-avatar'),
    ),
    'BH' => array(),
    'BI' => array(),
    'BJ' => array( // Beninese states.
        'AL' => __('Alibori', 'wp-user-avatar'),
        'AK' => __('Atakora', 'wp-user-avatar'),
        'AQ' => __('Atlantique', 'wp-user-avatar'),
        'BO' => __('Borgou', 'wp-user-avatar'),
        'CO' => __('Collines', 'wp-user-avatar'),
        'KO' => __('Kouffo', 'wp-user-avatar'),
        'DO' => __('Donga', 'wp-user-avatar'),
        'LI' => __('Littoral', 'wp-user-avatar'),
        'MO' => __('Mono', 'wp-user-avatar'),
        'OU' => __('Ouémé', 'wp-user-avatar'),
        'PL' => __('Plateau', 'wp-user-avatar'),
        'ZO' => __('Zou', 'wp-user-avatar'),
    ),
    'BO' => array( // Bolivian states.
        'BO-B' => __('Beni', 'wp-user-avatar'),
        'BO-H' => __('Chuquisaca', 'wp-user-avatar'),
        'BO-C' => __('Cochabamba', 'wp-user-avatar'),
        'BO-L' => __('La Paz', 'wp-user-avatar'),
        'BO-O' => __('Oruro', 'wp-user-avatar'),
        'BO-N' => __('Pando', 'wp-user-avatar'),
        'BO-P' => __('Potosí', 'wp-user-avatar'),
        'BO-S' => __('Santa Cruz', 'wp-user-avatar'),
        'BO-T' => __('Tarija', 'wp-user-avatar'),
    ),
    'BR' => array( // Brazilian states.
        'AC' => __('Acre', 'wp-user-avatar'),
        'AL' => __('Alagoas', 'wp-user-avatar'),
        'AP' => __('Amapá', 'wp-user-avatar'),
        'AM' => __('Amazonas', 'wp-user-avatar'),
        'BA' => __('Bahia', 'wp-user-avatar'),
        'CE' => __('Ceará', 'wp-user-avatar'),
        'DF' => __('Distrito Federal', 'wp-user-avatar'),
        'ES' => __('Espírito Santo', 'wp-user-avatar'),
        'GO' => __('Goiás', 'wp-user-avatar'),
        'MA' => __('Maranhão', 'wp-user-avatar'),
        'MT' => __('Mato Grosso', 'wp-user-avatar'),
        'MS' => __('Mato Grosso do Sul', 'wp-user-avatar'),
        'MG' => __('Minas Gerais', 'wp-user-avatar'),
        'PA' => __('Pará', 'wp-user-avatar'),
        'PB' => __('Paraíba', 'wp-user-avatar'),
        'PR' => __('Paraná', 'wp-user-avatar'),
        'PE' => __('Pernambuco', 'wp-user-avatar'),
        'PI' => __('Piauí', 'wp-user-avatar'),
        'RJ' => __('Rio de Janeiro', 'wp-user-avatar'),
        'RN' => __('Rio Grande do Norte', 'wp-user-avatar'),
        'RS' => __('Rio Grande do Sul', 'wp-user-avatar'),
        'RO' => __('Rondônia', 'wp-user-avatar'),
        'RR' => __('Roraima', 'wp-user-avatar'),
        'SC' => __('Santa Catarina', 'wp-user-avatar'),
        'SP' => __('São Paulo', 'wp-user-avatar'),
        'SE' => __('Sergipe', 'wp-user-avatar'),
        'TO' => __('Tocantins', 'wp-user-avatar'),
    ),
    'CA' => array( // Canadian states.
        'AB' => __('Alberta', 'wp-user-avatar'),
        'BC' => __('British Columbia', 'wp-user-avatar'),
        'MB' => __('Manitoba', 'wp-user-avatar'),
        'NB' => __('New Brunswick', 'wp-user-avatar'),
        'NL' => __('Newfoundland and Labrador', 'wp-user-avatar'),
        'NT' => __('Northwest Territories', 'wp-user-avatar'),
        'NS' => __('Nova Scotia', 'wp-user-avatar'),
        'NU' => __('Nunavut', 'wp-user-avatar'),
        'ON' => __('Ontario', 'wp-user-avatar'),
        'PE' => __('Prince Edward Island', 'wp-user-avatar'),
        'QC' => __('Quebec', 'wp-user-avatar'),
        'SK' => __('Saskatchewan', 'wp-user-avatar'),
        'YT' => __('Yukon Territory', 'wp-user-avatar'),
    ),
    'CH' => array( // Swiss cantons.
        'AG' => __('Aargau', 'wp-user-avatar'),
        'AR' => __('Appenzell Ausserrhoden', 'wp-user-avatar'),
        'AI' => __('Appenzell Innerrhoden', 'wp-user-avatar'),
        'BL' => __('Basel-Landschaft', 'wp-user-avatar'),
        'BS' => __('Basel-Stadt', 'wp-user-avatar'),
        'BE' => __('Bern', 'wp-user-avatar'),
        'FR' => __('Fribourg', 'wp-user-avatar'),
        'GE' => __('Geneva', 'wp-user-avatar'),
        'GL' => __('Glarus', 'wp-user-avatar'),
        'GR' => __('Graubünden', 'wp-user-avatar'),
        'JU' => __('Jura', 'wp-user-avatar'),
        'LU' => __('Luzern', 'wp-user-avatar'),
        'NE' => __('Neuchâtel', 'wp-user-avatar'),
        'NW' => __('Nidwalden', 'wp-user-avatar'),
        'OW' => __('Obwalden', 'wp-user-avatar'),
        'SH' => __('Schaffhausen', 'wp-user-avatar'),
        'SZ' => __('Schwyz', 'wp-user-avatar'),
        'SO' => __('Solothurn', 'wp-user-avatar'),
        'SG' => __('St. Gallen', 'wp-user-avatar'),
        'TG' => __('Thurgau', 'wp-user-avatar'),
        'TI' => __('Ticino', 'wp-user-avatar'),
        'UR' => __('Uri', 'wp-user-avatar'),
        'VS' => __('Valais', 'wp-user-avatar'),
        'VD' => __('Vaud', 'wp-user-avatar'),
        'ZG' => __('Zug', 'wp-user-avatar'),
        'ZH' => __('Zürich', 'wp-user-avatar'),
    ),
    'CL' => array( // Chilean states.
        'CL-AI' => __('Aisén del General Carlos Ibañez del Campo', 'wp-user-avatar'),
        'CL-AN' => __('Antofagasta', 'wp-user-avatar'),
        'CL-AP' => __('Arica y Parinacota', 'wp-user-avatar'),
        'CL-AR' => __('La Araucanía', 'wp-user-avatar'),
        'CL-AT' => __('Atacama', 'wp-user-avatar'),
        'CL-BI' => __('Biobío', 'wp-user-avatar'),
        'CL-CO' => __('Coquimbo', 'wp-user-avatar'),
        'CL-LI' => __('Libertador General Bernardo O\'Higgins', 'wp-user-avatar'),
        'CL-LL' => __('Los Lagos', 'wp-user-avatar'),
        'CL-LR' => __('Los Ríos', 'wp-user-avatar'),
        'CL-MA' => __('Magallanes', 'wp-user-avatar'),
        'CL-ML' => __('Maule', 'wp-user-avatar'),
        'CL-NB' => __('Ñuble', 'wp-user-avatar'),
        'CL-RM' => __('Región Metropolitana de Santiago', 'wp-user-avatar'),
        'CL-TA' => __('Tarapacá', 'wp-user-avatar'),
        'CL-VS' => __('Valparaíso', 'wp-user-avatar'),
    ),
    'CN' => array( // Chinese states.
        'CN1'  => __('Yunnan / 云南', 'wp-user-avatar'),
        'CN2'  => __('Beijing / 北京', 'wp-user-avatar'),
        'CN3'  => __('Tianjin / 天津', 'wp-user-avatar'),
        'CN4'  => __('Hebei / 河北', 'wp-user-avatar'),
        'CN5'  => __('Shanxi / 山西', 'wp-user-avatar'),
        'CN6'  => __('Inner Mongolia / 內蒙古', 'wp-user-avatar'),
        'CN7'  => __('Liaoning / 辽宁', 'wp-user-avatar'),
        'CN8'  => __('Jilin / 吉林', 'wp-user-avatar'),
        'CN9'  => __('Heilongjiang / 黑龙江', 'wp-user-avatar'),
        'CN10' => __('Shanghai / 上海', 'wp-user-avatar'),
        'CN11' => __('Jiangsu / 江苏', 'wp-user-avatar'),
        'CN12' => __('Zhejiang / 浙江', 'wp-user-avatar'),
        'CN13' => __('Anhui / 安徽', 'wp-user-avatar'),
        'CN14' => __('Fujian / 福建', 'wp-user-avatar'),
        'CN15' => __('Jiangxi / 江西', 'wp-user-avatar'),
        'CN16' => __('Shandong / 山东', 'wp-user-avatar'),
        'CN17' => __('Henan / 河南', 'wp-user-avatar'),
        'CN18' => __('Hubei / 湖北', 'wp-user-avatar'),
        'CN19' => __('Hunan / 湖南', 'wp-user-avatar'),
        'CN20' => __('Guangdong / 广东', 'wp-user-avatar'),
        'CN21' => __('Guangxi Zhuang / 广西壮族', 'wp-user-avatar'),
        'CN22' => __('Hainan / 海南', 'wp-user-avatar'),
        'CN23' => __('Chongqing / 重庆', 'wp-user-avatar'),
        'CN24' => __('Sichuan / 四川', 'wp-user-avatar'),
        'CN25' => __('Guizhou / 贵州', 'wp-user-avatar'),
        'CN26' => __('Shaanxi / 陕西', 'wp-user-avatar'),
        'CN27' => __('Gansu / 甘肃', 'wp-user-avatar'),
        'CN28' => __('Qinghai / 青海', 'wp-user-avatar'),
        'CN29' => __('Ningxia Hui / 宁夏', 'wp-user-avatar'),
        'CN30' => __('Macao / 澳门', 'wp-user-avatar'),
        'CN31' => __('Tibet / 西藏', 'wp-user-avatar'),
        'CN32' => __('Xinjiang / 新疆', 'wp-user-avatar'),
    ),
    'CO' => array( // Colombian states.
        'CO-AMA' => __('Amazonas', 'wp-user-avatar'),
        'CO-ANT' => __('Antioquia', 'wp-user-avatar'),
        'CO-ARA' => __('Arauca', 'wp-user-avatar'),
        'CO-ATL' => __('Atlántico', 'wp-user-avatar'),
        'CO-BOL' => __('Bolívar', 'wp-user-avatar'),
        'CO-BOY' => __('Boyacá', 'wp-user-avatar'),
        'CO-CAL' => __('Caldas', 'wp-user-avatar'),
        'CO-CAQ' => __('Caquetá', 'wp-user-avatar'),
        'CO-CAS' => __('Casanare', 'wp-user-avatar'),
        'CO-CAU' => __('Cauca', 'wp-user-avatar'),
        'CO-CES' => __('Cesar', 'wp-user-avatar'),
        'CO-CHO' => __('Chocó', 'wp-user-avatar'),
        'CO-COR' => __('Córdoba', 'wp-user-avatar'),
        'CO-CUN' => __('Cundinamarca', 'wp-user-avatar'),
        'CO-DC'  => __('Capital District', 'wp-user-avatar'),
        'CO-GUA' => __('Guainía', 'wp-user-avatar'),
        'CO-GUV' => __('Guaviare', 'wp-user-avatar'),
        'CO-HUI' => __('Huila', 'wp-user-avatar'),
        'CO-LAG' => __('La Guajira', 'wp-user-avatar'),
        'CO-MAG' => __('Magdalena', 'wp-user-avatar'),
        'CO-MET' => __('Meta', 'wp-user-avatar'),
        'CO-NAR' => __('Nariño', 'wp-user-avatar'),
        'CO-NSA' => __('Norte de Santander', 'wp-user-avatar'),
        'CO-PUT' => __('Putumayo', 'wp-user-avatar'),
        'CO-QUI' => __('Quindío', 'wp-user-avatar'),
        'CO-RIS' => __('Risaralda', 'wp-user-avatar'),
        'CO-SAN' => __('Santander', 'wp-user-avatar'),
        'CO-SAP' => __('San Andrés & Providencia', 'wp-user-avatar'),
        'CO-SUC' => __('Sucre', 'wp-user-avatar'),
        'CO-TOL' => __('Tolima', 'wp-user-avatar'),
        'CO-VAC' => __('Valle del Cauca', 'wp-user-avatar'),
        'CO-VAU' => __('Vaupés', 'wp-user-avatar'),
        'CO-VID' => __('Vichada', 'wp-user-avatar'),
    ),
    'CR' => array( // Costa Rican states.
        'CR-A'  => __('Alajuela', 'wp-user-avatar'),
        'CR-C'  => __('Cartago', 'wp-user-avatar'),
        'CR-G'  => __('Guanacaste', 'wp-user-avatar'),
        'CR-H'  => __('Heredia', 'wp-user-avatar'),
        'CR-L'  => __('Limón', 'wp-user-avatar'),
        'CR-P'  => __('Puntarenas', 'wp-user-avatar'),
        'CR-SJ' => __('San José', 'wp-user-avatar'),
    ),
    'CZ' => array(),
    'DE' => array( // German states.
        'DE-BW' => __('Baden-Württemberg', 'wp-user-avatar'),
        'DE-BY' => __('Bavaria', 'wp-user-avatar'),
        'DE-BE' => __('Berlin', 'wp-user-avatar'),
        'DE-BB' => __('Brandenburg', 'wp-user-avatar'),
        'DE-HB' => __('Bremen', 'wp-user-avatar'),
        'DE-HH' => __('Hamburg', 'wp-user-avatar'),
        'DE-HE' => __('Hesse', 'wp-user-avatar'),
        'DE-MV' => __('Mecklenburg-Vorpommern', 'wp-user-avatar'),
        'DE-NI' => __('Lower Saxony', 'wp-user-avatar'),
        'DE-NW' => __('North Rhine-Westphalia', 'wp-user-avatar'),
        'DE-RP' => __('Rhineland-Palatinate', 'wp-user-avatar'),
        'DE-SL' => __('Saarland', 'wp-user-avatar'),
        'DE-SN' => __('Saxony', 'wp-user-avatar'),
        'DE-ST' => __('Saxony-Anhalt', 'wp-user-avatar'),
        'DE-SH' => __('Schleswig-Holstein', 'wp-user-avatar'),
        'DE-TH' => __('Thuringia', 'wp-user-avatar'),
    ),
    'DK' => array(),
    'DO' => array( // Dominican states.
        'DO-01' => __('Distrito Nacional', 'wp-user-avatar'),
        'DO-02' => __('Azua', 'wp-user-avatar'),
        'DO-03' => __('Baoruco', 'wp-user-avatar'),
        'DO-04' => __('Barahona', 'wp-user-avatar'),
        'DO-33' => __('Cibao Nordeste', 'wp-user-avatar'),
        'DO-34' => __('Cibao Noroeste', 'wp-user-avatar'),
        'DO-35' => __('Cibao Norte', 'wp-user-avatar'),
        'DO-36' => __('Cibao Sur', 'wp-user-avatar'),
        'DO-05' => __('Dajabón', 'wp-user-avatar'),
        'DO-06' => __('Duarte', 'wp-user-avatar'),
        'DO-08' => __('El Seibo', 'wp-user-avatar'),
        'DO-37' => __('El Valle', 'wp-user-avatar'),
        'DO-07' => __('Elías Piña', 'wp-user-avatar'),
        'DO-38' => __('Enriquillo', 'wp-user-avatar'),
        'DO-09' => __('Espaillat', 'wp-user-avatar'),
        'DO-30' => __('Hato Mayor', 'wp-user-avatar'),
        'DO-19' => __('Hermanas Mirabal', 'wp-user-avatar'),
        'DO-39' => __('Higüamo', 'wp-user-avatar'),
        'DO-10' => __('Independencia', 'wp-user-avatar'),
        'DO-11' => __('La Altagracia', 'wp-user-avatar'),
        'DO-12' => __('La Romana', 'wp-user-avatar'),
        'DO-13' => __('La Vega', 'wp-user-avatar'),
        'DO-14' => __('María Trinidad Sánchez', 'wp-user-avatar'),
        'DO-28' => __('Monseñor Nouel', 'wp-user-avatar'),
        'DO-15' => __('Monte Cristi', 'wp-user-avatar'),
        'DO-29' => __('Monte Plata', 'wp-user-avatar'),
        'DO-40' => __('Ozama', 'wp-user-avatar'),
        'DO-16' => __('Pedernales', 'wp-user-avatar'),
        'DO-17' => __('Peravia', 'wp-user-avatar'),
        'DO-18' => __('Puerto Plata', 'wp-user-avatar'),
        'DO-20' => __('Samaná', 'wp-user-avatar'),
        'DO-21' => __('San Cristóbal', 'wp-user-avatar'),
        'DO-31' => __('San José de Ocoa', 'wp-user-avatar'),
        'DO-22' => __('San Juan', 'wp-user-avatar'),
        'DO-23' => __('San Pedro de Macorís', 'wp-user-avatar'),
        'DO-24' => __('Sánchez Ramírez', 'wp-user-avatar'),
        'DO-25' => __('Santiago', 'wp-user-avatar'),
        'DO-26' => __('Santiago Rodríguez', 'wp-user-avatar'),
        'DO-32' => __('Santo Domingo', 'wp-user-avatar'),
        'DO-41' => __('Valdesia', 'wp-user-avatar'),
        'DO-27' => __('Valverde', 'wp-user-avatar'),
        'DO-42' => __('Yuma', 'wp-user-avatar'),
    ),
    'DZ' => array( // Algerian states.
        'DZ-01' => __('Adrar', 'wp-user-avatar'),
        'DZ-02' => __('Chlef', 'wp-user-avatar'),
        'DZ-03' => __('Laghouat', 'wp-user-avatar'),
        'DZ-04' => __('Oum El Bouaghi', 'wp-user-avatar'),
        'DZ-05' => __('Batna', 'wp-user-avatar'),
        'DZ-06' => __('Béjaïa', 'wp-user-avatar'),
        'DZ-07' => __('Biskra', 'wp-user-avatar'),
        'DZ-08' => __('Béchar', 'wp-user-avatar'),
        'DZ-09' => __('Blida', 'wp-user-avatar'),
        'DZ-10' => __('Bouira', 'wp-user-avatar'),
        'DZ-11' => __('Tamanghasset', 'wp-user-avatar'),
        'DZ-12' => __('Tébessa', 'wp-user-avatar'),
        'DZ-13' => __('Tlemcen', 'wp-user-avatar'),
        'DZ-14' => __('Tiaret', 'wp-user-avatar'),
        'DZ-15' => __('Tizi Ouzou', 'wp-user-avatar'),
        'DZ-16' => __('Algiers', 'wp-user-avatar'),
        'DZ-17' => __('Djelfa', 'wp-user-avatar'),
        'DZ-18' => __('Jijel', 'wp-user-avatar'),
        'DZ-19' => __('Sétif', 'wp-user-avatar'),
        'DZ-20' => __('Saïda', 'wp-user-avatar'),
        'DZ-21' => __('Skikda', 'wp-user-avatar'),
        'DZ-22' => __('Sidi Bel Abbès', 'wp-user-avatar'),
        'DZ-23' => __('Annaba', 'wp-user-avatar'),
        'DZ-24' => __('Guelma', 'wp-user-avatar'),
        'DZ-25' => __('Constantine', 'wp-user-avatar'),
        'DZ-26' => __('Médéa', 'wp-user-avatar'),
        'DZ-27' => __('Mostaganem', 'wp-user-avatar'),
        'DZ-28' => __('M’Sila', 'wp-user-avatar'),
        'DZ-29' => __('Mascara', 'wp-user-avatar'),
        'DZ-30' => __('Ouargla', 'wp-user-avatar'),
        'DZ-31' => __('Oran', 'wp-user-avatar'),
        'DZ-32' => __('El Bayadh', 'wp-user-avatar'),
        'DZ-33' => __('Illizi', 'wp-user-avatar'),
        'DZ-34' => __('Bordj Bou Arréridj', 'wp-user-avatar'),
        'DZ-35' => __('Boumerdès', 'wp-user-avatar'),
        'DZ-36' => __('El Tarf', 'wp-user-avatar'),
        'DZ-37' => __('Tindouf', 'wp-user-avatar'),
        'DZ-38' => __('Tissemsilt', 'wp-user-avatar'),
        'DZ-39' => __('El Oued', 'wp-user-avatar'),
        'DZ-40' => __('Khenchela', 'wp-user-avatar'),
        'DZ-41' => __('Souk Ahras', 'wp-user-avatar'),
        'DZ-42' => __('Tipasa', 'wp-user-avatar'),
        'DZ-43' => __('Mila', 'wp-user-avatar'),
        'DZ-44' => __('Aïn Defla', 'wp-user-avatar'),
        'DZ-45' => __('Naama', 'wp-user-avatar'),
        'DZ-46' => __('Aïn Témouchent', 'wp-user-avatar'),
        'DZ-47' => __('Ghardaïa', 'wp-user-avatar'),
        'DZ-48' => __('Relizane', 'wp-user-avatar'),
    ),
    'EE' => array(),
    'EC' => array( // Ecuadorian states.
        'EC-A'  => __('Azuay', 'wp-user-avatar'),
        'EC-B'  => __('Bolívar', 'wp-user-avatar'),
        'EC-F'  => __('Cañar', 'wp-user-avatar'),
        'EC-C'  => __('Carchi', 'wp-user-avatar'),
        'EC-H'  => __('Chimborazo', 'wp-user-avatar'),
        'EC-X'  => __('Cotopaxi', 'wp-user-avatar'),
        'EC-O'  => __('El Oro', 'wp-user-avatar'),
        'EC-E'  => __('Esmeraldas', 'wp-user-avatar'),
        'EC-W'  => __('Galápagos', 'wp-user-avatar'),
        'EC-G'  => __('Guayas', 'wp-user-avatar'),
        'EC-I'  => __('Imbabura', 'wp-user-avatar'),
        'EC-L'  => __('Loja', 'wp-user-avatar'),
        'EC-R'  => __('Los Ríos', 'wp-user-avatar'),
        'EC-M'  => __('Manabí', 'wp-user-avatar'),
        'EC-S'  => __('Morona-Santiago', 'wp-user-avatar'),
        'EC-N'  => __('Napo', 'wp-user-avatar'),
        'EC-D'  => __('Orellana', 'wp-user-avatar'),
        'EC-Y'  => __('Pastaza', 'wp-user-avatar'),
        'EC-P'  => __('Pichincha', 'wp-user-avatar'),
        'EC-SE' => __('Santa Elena', 'wp-user-avatar'),
        'EC-SD' => __('Santo Domingo de los Tsáchilas', 'wp-user-avatar'),
        'EC-U'  => __('Sucumbíos', 'wp-user-avatar'),
        'EC-T'  => __('Tungurahua', 'wp-user-avatar'),
        'EC-Z'  => __('Zamora-Chinchipe', 'wp-user-avatar'),
    ),
    'EG' => array( // Egyptian states.
        'EGALX' => __('Alexandria', 'wp-user-avatar'),
        'EGASN' => __('Aswan', 'wp-user-avatar'),
        'EGAST' => __('Asyut', 'wp-user-avatar'),
        'EGBA'  => __('Red Sea', 'wp-user-avatar'),
        'EGBH'  => __('Beheira', 'wp-user-avatar'),
        'EGBNS' => __('Beni Suef', 'wp-user-avatar'),
        'EGC'   => __('Cairo', 'wp-user-avatar'),
        'EGDK'  => __('Dakahlia', 'wp-user-avatar'),
        'EGDT'  => __('Damietta', 'wp-user-avatar'),
        'EGFYM' => __('Faiyum', 'wp-user-avatar'),
        'EGGH'  => __('Gharbia', 'wp-user-avatar'),
        'EGGZ'  => __('Giza', 'wp-user-avatar'),
        'EGIS'  => __('Ismailia', 'wp-user-avatar'),
        'EGJS'  => __('South Sinai', 'wp-user-avatar'),
        'EGKB'  => __('Qalyubia', 'wp-user-avatar'),
        'EGKFS' => __('Kafr el-Sheikh', 'wp-user-avatar'),
        'EGKN'  => __('Qena', 'wp-user-avatar'),
        'EGLX'  => __('Luxor', 'wp-user-avatar'),
        'EGMN'  => __('Minya', 'wp-user-avatar'),
        'EGMNF' => __('Monufia', 'wp-user-avatar'),
        'EGMT'  => __('Matrouh', 'wp-user-avatar'),
        'EGPTS' => __('Port Said', 'wp-user-avatar'),
        'EGSHG' => __('Sohag', 'wp-user-avatar'),
        'EGSHR' => __('Al Sharqia', 'wp-user-avatar'),
        'EGSIN' => __('North Sinai', 'wp-user-avatar'),
        'EGSUZ' => __('Suez', 'wp-user-avatar'),
        'EGWAD' => __('New Valley', 'wp-user-avatar'),
    ),
    'ES' => array( // Spanish states.
        'C'  => __('A Coruña', 'wp-user-avatar'),
        'VI' => __('Araba/Álava', 'wp-user-avatar'),
        'AB' => __('Albacete', 'wp-user-avatar'),
        'A'  => __('Alicante', 'wp-user-avatar'),
        'AL' => __('Almería', 'wp-user-avatar'),
        'O'  => __('Asturias', 'wp-user-avatar'),
        'AV' => __('Ávila', 'wp-user-avatar'),
        'BA' => __('Badajoz', 'wp-user-avatar'),
        'PM' => __('Baleares', 'wp-user-avatar'),
        'B'  => __('Barcelona', 'wp-user-avatar'),
        'BU' => __('Burgos', 'wp-user-avatar'),
        'CC' => __('Cáceres', 'wp-user-avatar'),
        'CA' => __('Cádiz', 'wp-user-avatar'),
        'S'  => __('Cantabria', 'wp-user-avatar'),
        'CS' => __('Castellón', 'wp-user-avatar'),
        'CE' => __('Ceuta', 'wp-user-avatar'),
        'CR' => __('Ciudad Real', 'wp-user-avatar'),
        'CO' => __('Córdoba', 'wp-user-avatar'),
        'CU' => __('Cuenca', 'wp-user-avatar'),
        'GI' => __('Girona', 'wp-user-avatar'),
        'GR' => __('Granada', 'wp-user-avatar'),
        'GU' => __('Guadalajara', 'wp-user-avatar'),
        'SS' => __('Gipuzkoa', 'wp-user-avatar'),
        'H'  => __('Huelva', 'wp-user-avatar'),
        'HU' => __('Huesca', 'wp-user-avatar'),
        'J'  => __('Jaén', 'wp-user-avatar'),
        'LO' => __('La Rioja', 'wp-user-avatar'),
        'GC' => __('Las Palmas', 'wp-user-avatar'),
        'LE' => __('León', 'wp-user-avatar'),
        'L'  => __('Lleida', 'wp-user-avatar'),
        'LU' => __('Lugo', 'wp-user-avatar'),
        'M'  => __('Madrid', 'wp-user-avatar'),
        'MA' => __('Málaga', 'wp-user-avatar'),
        'ML' => __('Melilla', 'wp-user-avatar'),
        'MU' => __('Murcia', 'wp-user-avatar'),
        'NA' => __('Navarra', 'wp-user-avatar'),
        'OR' => __('Ourense', 'wp-user-avatar'),
        'P'  => __('Palencia', 'wp-user-avatar'),
        'PO' => __('Pontevedra', 'wp-user-avatar'),
        'SA' => __('Salamanca', 'wp-user-avatar'),
        'TF' => __('Santa Cruz de Tenerife', 'wp-user-avatar'),
        'SG' => __('Segovia', 'wp-user-avatar'),
        'SE' => __('Sevilla', 'wp-user-avatar'),
        'SO' => __('Soria', 'wp-user-avatar'),
        'T'  => __('Tarragona', 'wp-user-avatar'),
        'TE' => __('Teruel', 'wp-user-avatar'),
        'TO' => __('Toledo', 'wp-user-avatar'),
        'V'  => __('Valencia', 'wp-user-avatar'),
        'VA' => __('Valladolid', 'wp-user-avatar'),
        'BI' => __('Biscay', 'wp-user-avatar'),
        'ZA' => __('Zamora', 'wp-user-avatar'),
        'Z'  => __('Zaragoza', 'wp-user-avatar'),
    ),
    'ET' => array(),
    'FI' => array(),
    'FR' => array(),
    'GF' => array(),
    'GH' => array( // Ghanaian regions.
        'AF' => __('Ahafo', 'wp-user-avatar'),
        'AH' => __('Ashanti', 'wp-user-avatar'),
        'BA' => __('Brong-Ahafo', 'wp-user-avatar'),
        'BO' => __('Bono', 'wp-user-avatar'),
        'BE' => __('Bono East', 'wp-user-avatar'),
        'CP' => __('Central', 'wp-user-avatar'),
        'EP' => __('Eastern', 'wp-user-avatar'),
        'AA' => __('Greater Accra', 'wp-user-avatar'),
        'NE' => __('North East', 'wp-user-avatar'),
        'NP' => __('Northern', 'wp-user-avatar'),
        'OT' => __('Oti', 'wp-user-avatar'),
        'SV' => __('Savannah', 'wp-user-avatar'),
        'UE' => __('Upper East', 'wp-user-avatar'),
        'UW' => __('Upper West', 'wp-user-avatar'),
        'TV' => __('Volta', 'wp-user-avatar'),
        'WP' => __('Western', 'wp-user-avatar'),
        'WN' => __('Western North', 'wp-user-avatar'),
    ),
    'GP' => array(),
    'GR' => array( // Greek regions.
        'I' => __('Attica', 'wp-user-avatar'),
        'A' => __('East Macedonia and Thrace', 'wp-user-avatar'),
        'B' => __('Central Macedonia', 'wp-user-avatar'),
        'C' => __('West Macedonia', 'wp-user-avatar'),
        'D' => __('Epirus', 'wp-user-avatar'),
        'E' => __('Thessaly', 'wp-user-avatar'),
        'F' => __('Ionian Islands', 'wp-user-avatar'),
        'G' => __('West Greece', 'wp-user-avatar'),
        'H' => __('Central Greece', 'wp-user-avatar'),
        'J' => __('Peloponnese', 'wp-user-avatar'),
        'K' => __('North Aegean', 'wp-user-avatar'),
        'L' => __('South Aegean', 'wp-user-avatar'),
        'M' => __('Crete', 'wp-user-avatar'),
    ),
    'GT' => array( // Guatemalan states.
        'GT-AV' => __('Alta Verapaz', 'wp-user-avatar'),
        'GT-BV' => __('Baja Verapaz', 'wp-user-avatar'),
        'GT-CM' => __('Chimaltenango', 'wp-user-avatar'),
        'GT-CQ' => __('Chiquimula', 'wp-user-avatar'),
        'GT-PR' => __('El Progreso', 'wp-user-avatar'),
        'GT-ES' => __('Escuintla', 'wp-user-avatar'),
        'GT-GU' => __('Guatemala', 'wp-user-avatar'),
        'GT-HU' => __('Huehuetenango', 'wp-user-avatar'),
        'GT-IZ' => __('Izabal', 'wp-user-avatar'),
        'GT-JA' => __('Jalapa', 'wp-user-avatar'),
        'GT-JU' => __('Jutiapa', 'wp-user-avatar'),
        'GT-PE' => __('Petén', 'wp-user-avatar'),
        'GT-QZ' => __('Quetzaltenango', 'wp-user-avatar'),
        'GT-QC' => __('Quiché', 'wp-user-avatar'),
        'GT-RE' => __('Retalhuleu', 'wp-user-avatar'),
        'GT-SA' => __('Sacatepéquez', 'wp-user-avatar'),
        'GT-SM' => __('San Marcos', 'wp-user-avatar'),
        'GT-SR' => __('Santa Rosa', 'wp-user-avatar'),
        'GT-SO' => __('Sololá', 'wp-user-avatar'),
        'GT-SU' => __('Suchitepéquez', 'wp-user-avatar'),
        'GT-TO' => __('Totonicapán', 'wp-user-avatar'),
        'GT-ZA' => __('Zacapa', 'wp-user-avatar'),
    ),
    'HK' => array( // Hong Kong states.
        'HONG KONG'       => __('Hong Kong Island', 'wp-user-avatar'),
        'KOWLOON'         => __('Kowloon', 'wp-user-avatar'),
        'NEW TERRITORIES' => __('New Territories', 'wp-user-avatar'),
    ),
    'HN' => array( // Honduran states.
        'HN-AT' => __('Atlántida', 'wp-user-avatar'),
        'HN-IB' => __('Bay Islands', 'wp-user-avatar'),
        'HN-CH' => __('Choluteca', 'wp-user-avatar'),
        'HN-CL' => __('Colón', 'wp-user-avatar'),
        'HN-CM' => __('Comayagua', 'wp-user-avatar'),
        'HN-CP' => __('Copán', 'wp-user-avatar'),
        'HN-CR' => __('Cortés', 'wp-user-avatar'),
        'HN-EP' => __('El Paraíso', 'wp-user-avatar'),
        'HN-FM' => __('Francisco Morazán', 'wp-user-avatar'),
        'HN-GD' => __('Gracias a Dios', 'wp-user-avatar'),
        'HN-IN' => __('Intibucá', 'wp-user-avatar'),
        'HN-LE' => __('Lempira', 'wp-user-avatar'),
        'HN-LP' => __('La Paz', 'wp-user-avatar'),
        'HN-OC' => __('Ocotepeque', 'wp-user-avatar'),
        'HN-OL' => __('Olancho', 'wp-user-avatar'),
        'HN-SB' => __('Santa Bárbara', 'wp-user-avatar'),
        'HN-VA' => __('Valle', 'wp-user-avatar'),
        'HN-YO' => __('Yoro', 'wp-user-avatar'),
    ),
    'HU' => array( // Hungarian states.
        'BK' => __('Bács-Kiskun', 'wp-user-avatar'),
        'BE' => __('Békés', 'wp-user-avatar'),
        'BA' => __('Baranya', 'wp-user-avatar'),
        'BZ' => __('Borsod-Abaúj-Zemplén', 'wp-user-avatar'),
        'BU' => __('Budapest', 'wp-user-avatar'),
        'CS' => __('Csongrád-Csanád', 'wp-user-avatar'),
        'FE' => __('Fejér', 'wp-user-avatar'),
        'GS' => __('Győr-Moson-Sopron', 'wp-user-avatar'),
        'HB' => __('Hajdú-Bihar', 'wp-user-avatar'),
        'HE' => __('Heves', 'wp-user-avatar'),
        'JN' => __('Jász-Nagykun-Szolnok', 'wp-user-avatar'),
        'KE' => __('Komárom-Esztergom', 'wp-user-avatar'),
        'NO' => __('Nógrád', 'wp-user-avatar'),
        'PE' => __('Pest', 'wp-user-avatar'),
        'SO' => __('Somogy', 'wp-user-avatar'),
        'SZ' => __('Szabolcs-Szatmár-Bereg', 'wp-user-avatar'),
        'TO' => __('Tolna', 'wp-user-avatar'),
        'VA' => __('Vas', 'wp-user-avatar'),
        'VE' => __('Veszprém', 'wp-user-avatar'),
        'ZA' => __('Zala', 'wp-user-avatar'),
    ),
    'ID' => array( // Indonesian provinces.
        'AC' => __('Daerah Istimewa Aceh', 'wp-user-avatar'),
        'SU' => __('Sumatera Utara', 'wp-user-avatar'),
        'SB' => __('Sumatera Barat', 'wp-user-avatar'),
        'RI' => __('Riau', 'wp-user-avatar'),
        'KR' => __('Kepulauan Riau', 'wp-user-avatar'),
        'JA' => __('Jambi', 'wp-user-avatar'),
        'SS' => __('Sumatera Selatan', 'wp-user-avatar'),
        'BB' => __('Bangka Belitung', 'wp-user-avatar'),
        'BE' => __('Bengkulu', 'wp-user-avatar'),
        'LA' => __('Lampung', 'wp-user-avatar'),
        'JK' => __('DKI Jakarta', 'wp-user-avatar'),
        'JB' => __('Jawa Barat', 'wp-user-avatar'),
        'BT' => __('Banten', 'wp-user-avatar'),
        'JT' => __('Jawa Tengah', 'wp-user-avatar'),
        'JI' => __('Jawa Timur', 'wp-user-avatar'),
        'YO' => __('Daerah Istimewa Yogyakarta', 'wp-user-avatar'),
        'BA' => __('Bali', 'wp-user-avatar'),
        'NB' => __('Nusa Tenggara Barat', 'wp-user-avatar'),
        'NT' => __('Nusa Tenggara Timur', 'wp-user-avatar'),
        'KB' => __('Kalimantan Barat', 'wp-user-avatar'),
        'KT' => __('Kalimantan Tengah', 'wp-user-avatar'),
        'KI' => __('Kalimantan Timur', 'wp-user-avatar'),
        'KS' => __('Kalimantan Selatan', 'wp-user-avatar'),
        'KU' => __('Kalimantan Utara', 'wp-user-avatar'),
        'SA' => __('Sulawesi Utara', 'wp-user-avatar'),
        'ST' => __('Sulawesi Tengah', 'wp-user-avatar'),
        'SG' => __('Sulawesi Tenggara', 'wp-user-avatar'),
        'SR' => __('Sulawesi Barat', 'wp-user-avatar'),
        'SN' => __('Sulawesi Selatan', 'wp-user-avatar'),
        'GO' => __('Gorontalo', 'wp-user-avatar'),
        'MA' => __('Maluku', 'wp-user-avatar'),
        'MU' => __('Maluku Utara', 'wp-user-avatar'),
        'PA' => __('Papua', 'wp-user-avatar'),
        'PB' => __('Papua Barat', 'wp-user-avatar'),
    ),
    'IE' => array( // Irish states.
        'CW' => __('Carlow', 'wp-user-avatar'),
        'CN' => __('Cavan', 'wp-user-avatar'),
        'CE' => __('Clare', 'wp-user-avatar'),
        'CO' => __('Cork', 'wp-user-avatar'),
        'DL' => __('Donegal', 'wp-user-avatar'),
        'D'  => __('Dublin', 'wp-user-avatar'),
        'G'  => __('Galway', 'wp-user-avatar'),
        'KY' => __('Kerry', 'wp-user-avatar'),
        'KE' => __('Kildare', 'wp-user-avatar'),
        'KK' => __('Kilkenny', 'wp-user-avatar'),
        'LS' => __('Laois', 'wp-user-avatar'),
        'LM' => __('Leitrim', 'wp-user-avatar'),
        'LK' => __('Limerick', 'wp-user-avatar'),
        'LD' => __('Longford', 'wp-user-avatar'),
        'LH' => __('Louth', 'wp-user-avatar'),
        'MO' => __('Mayo', 'wp-user-avatar'),
        'MH' => __('Meath', 'wp-user-avatar'),
        'MN' => __('Monaghan', 'wp-user-avatar'),
        'OY' => __('Offaly', 'wp-user-avatar'),
        'RN' => __('Roscommon', 'wp-user-avatar'),
        'SO' => __('Sligo', 'wp-user-avatar'),
        'TA' => __('Tipperary', 'wp-user-avatar'),
        'WD' => __('Waterford', 'wp-user-avatar'),
        'WH' => __('Westmeath', 'wp-user-avatar'),
        'WX' => __('Wexford', 'wp-user-avatar'),
        'WW' => __('Wicklow', 'wp-user-avatar'),
    ),
    'IN' => array( // Indian states.
        'AP' => __('Andhra Pradesh', 'wp-user-avatar'),
        'AR' => __('Arunachal Pradesh', 'wp-user-avatar'),
        'AS' => __('Assam', 'wp-user-avatar'),
        'BR' => __('Bihar', 'wp-user-avatar'),
        'CT' => __('Chhattisgarh', 'wp-user-avatar'),
        'GA' => __('Goa', 'wp-user-avatar'),
        'GJ' => __('Gujarat', 'wp-user-avatar'),
        'HR' => __('Haryana', 'wp-user-avatar'),
        'HP' => __('Himachal Pradesh', 'wp-user-avatar'),
        'JK' => __('Jammu and Kashmir', 'wp-user-avatar'),
        'JH' => __('Jharkhand', 'wp-user-avatar'),
        'KA' => __('Karnataka', 'wp-user-avatar'),
        'KL' => __('Kerala', 'wp-user-avatar'),
        'LA' => __('Ladakh', 'wp-user-avatar'),
        'MP' => __('Madhya Pradesh', 'wp-user-avatar'),
        'MH' => __('Maharashtra', 'wp-user-avatar'),
        'MN' => __('Manipur', 'wp-user-avatar'),
        'ML' => __('Meghalaya', 'wp-user-avatar'),
        'MZ' => __('Mizoram', 'wp-user-avatar'),
        'NL' => __('Nagaland', 'wp-user-avatar'),
        'OR' => __('Odisha', 'wp-user-avatar'),
        'PB' => __('Punjab', 'wp-user-avatar'),
        'RJ' => __('Rajasthan', 'wp-user-avatar'),
        'SK' => __('Sikkim', 'wp-user-avatar'),
        'TN' => __('Tamil Nadu', 'wp-user-avatar'),
        'TS' => __('Telangana', 'wp-user-avatar'),
        'TR' => __('Tripura', 'wp-user-avatar'),
        'UK' => __('Uttarakhand', 'wp-user-avatar'),
        'UP' => __('Uttar Pradesh', 'wp-user-avatar'),
        'WB' => __('West Bengal', 'wp-user-avatar'),
        'AN' => __('Andaman and Nicobar Islands', 'wp-user-avatar'),
        'CH' => __('Chandigarh', 'wp-user-avatar'),
        'DN' => __('Dadra and Nagar Haveli', 'wp-user-avatar'),
        'DD' => __('Daman and Diu', 'wp-user-avatar'),
        'DL' => __('Delhi', 'wp-user-avatar'),
        'LD' => __('Lakshadeep', 'wp-user-avatar'),
        'PY' => __('Pondicherry (Puducherry)', 'wp-user-avatar'),
    ),
    'IR' => array( // Iranian states.
        'KHZ' => __('Khuzestan (خوزستان)', 'wp-user-avatar'),
        'THR' => __('Tehran (تهران)', 'wp-user-avatar'),
        'ILM' => __('Ilaam (ایلام)', 'wp-user-avatar'),
        'BHR' => __('Bushehr (بوشهر)', 'wp-user-avatar'),
        'ADL' => __('Ardabil (اردبیل)', 'wp-user-avatar'),
        'ESF' => __('Isfahan (اصفهان)', 'wp-user-avatar'),
        'YZD' => __('Yazd (یزد)', 'wp-user-avatar'),
        'KRH' => __('Kermanshah (کرمانشاه)', 'wp-user-avatar'),
        'KRN' => __('Kerman (کرمان)', 'wp-user-avatar'),
        'HDN' => __('Hamadan (همدان)', 'wp-user-avatar'),
        'GZN' => __('Ghazvin (قزوین)', 'wp-user-avatar'),
        'ZJN' => __('Zanjan (زنجان)', 'wp-user-avatar'),
        'LRS' => __('Luristan (لرستان)', 'wp-user-avatar'),
        'ABZ' => __('Alborz (البرز)', 'wp-user-avatar'),
        'EAZ' => __('East Azarbaijan (آذربایجان شرقی)', 'wp-user-avatar'),
        'WAZ' => __('West Azarbaijan (آذربایجان غربی)', 'wp-user-avatar'),
        'CHB' => __('Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'wp-user-avatar'),
        'SKH' => __('South Khorasan (خراسان جنوبی)', 'wp-user-avatar'),
        'RKH' => __('Razavi Khorasan (خراسان رضوی)', 'wp-user-avatar'),
        'NKH' => __('North Khorasan (خراسان شمالی)', 'wp-user-avatar'),
        'SMN' => __('Semnan (سمنان)', 'wp-user-avatar'),
        'FRS' => __('Fars (فارس)', 'wp-user-avatar'),
        'QHM' => __('Qom (قم)', 'wp-user-avatar'),
        'KRD' => __('Kurdistan / کردستان)', 'wp-user-avatar'),
        'KBD' => __('Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'wp-user-avatar'),
        'GLS' => __('Golestan (گلستان)', 'wp-user-avatar'),
        'GIL' => __('Gilan (گیلان)', 'wp-user-avatar'),
        'MZN' => __('Mazandaran (مازندران)', 'wp-user-avatar'),
        'MKZ' => __('Markazi (مرکزی)', 'wp-user-avatar'),
        'HRZ' => __('Hormozgan (هرمزگان)', 'wp-user-avatar'),
        'SBN' => __('Sistan and Baluchestan (سیستان و بلوچستان)', 'wp-user-avatar'),
    ),
    'IS' => array(),
    'IT' => array( // Italian provinces.
        'AG' => __('Agrigento', 'wp-user-avatar'),
        'AL' => __('Alessandria', 'wp-user-avatar'),
        'AN' => __('Ancona', 'wp-user-avatar'),
        'AO' => __('Aosta', 'wp-user-avatar'),
        'AR' => __('Arezzo', 'wp-user-avatar'),
        'AP' => __('Ascoli Piceno', 'wp-user-avatar'),
        'AT' => __('Asti', 'wp-user-avatar'),
        'AV' => __('Avellino', 'wp-user-avatar'),
        'BA' => __('Bari', 'wp-user-avatar'),
        'BT' => __('Barletta-Andria-Trani', 'wp-user-avatar'),
        'BL' => __('Belluno', 'wp-user-avatar'),
        'BN' => __('Benevento', 'wp-user-avatar'),
        'BG' => __('Bergamo', 'wp-user-avatar'),
        'BI' => __('Biella', 'wp-user-avatar'),
        'BO' => __('Bologna', 'wp-user-avatar'),
        'BZ' => __('Bolzano', 'wp-user-avatar'),
        'BS' => __('Brescia', 'wp-user-avatar'),
        'BR' => __('Brindisi', 'wp-user-avatar'),
        'CA' => __('Cagliari', 'wp-user-avatar'),
        'CL' => __('Caltanissetta', 'wp-user-avatar'),
        'CB' => __('Campobasso', 'wp-user-avatar'),
        'CE' => __('Caserta', 'wp-user-avatar'),
        'CT' => __('Catania', 'wp-user-avatar'),
        'CZ' => __('Catanzaro', 'wp-user-avatar'),
        'CH' => __('Chieti', 'wp-user-avatar'),
        'CO' => __('Como', 'wp-user-avatar'),
        'CS' => __('Cosenza', 'wp-user-avatar'),
        'CR' => __('Cremona', 'wp-user-avatar'),
        'KR' => __('Crotone', 'wp-user-avatar'),
        'CN' => __('Cuneo', 'wp-user-avatar'),
        'EN' => __('Enna', 'wp-user-avatar'),
        'FM' => __('Fermo', 'wp-user-avatar'),
        'FE' => __('Ferrara', 'wp-user-avatar'),
        'FI' => __('Firenze', 'wp-user-avatar'),
        'FG' => __('Foggia', 'wp-user-avatar'),
        'FC' => __('Forlì-Cesena', 'wp-user-avatar'),
        'FR' => __('Frosinone', 'wp-user-avatar'),
        'GE' => __('Genova', 'wp-user-avatar'),
        'GO' => __('Gorizia', 'wp-user-avatar'),
        'GR' => __('Grosseto', 'wp-user-avatar'),
        'IM' => __('Imperia', 'wp-user-avatar'),
        'IS' => __('Isernia', 'wp-user-avatar'),
        'SP' => __('La Spezia', 'wp-user-avatar'),
        'AQ' => __("L'Aquila", 'wp-user-avatar'),
        'LT' => __('Latina', 'wp-user-avatar'),
        'LE' => __('Lecce', 'wp-user-avatar'),
        'LC' => __('Lecco', 'wp-user-avatar'),
        'LI' => __('Livorno', 'wp-user-avatar'),
        'LO' => __('Lodi', 'wp-user-avatar'),
        'LU' => __('Lucca', 'wp-user-avatar'),
        'MC' => __('Macerata', 'wp-user-avatar'),
        'MN' => __('Mantova', 'wp-user-avatar'),
        'MS' => __('Massa-Carrara', 'wp-user-avatar'),
        'MT' => __('Matera', 'wp-user-avatar'),
        'ME' => __('Messina', 'wp-user-avatar'),
        'MI' => __('Milano', 'wp-user-avatar'),
        'MO' => __('Modena', 'wp-user-avatar'),
        'MB' => __('Monza e della Brianza', 'wp-user-avatar'),
        'NA' => __('Napoli', 'wp-user-avatar'),
        'NO' => __('Novara', 'wp-user-avatar'),
        'NU' => __('Nuoro', 'wp-user-avatar'),
        'OR' => __('Oristano', 'wp-user-avatar'),
        'PD' => __('Padova', 'wp-user-avatar'),
        'PA' => __('Palermo', 'wp-user-avatar'),
        'PR' => __('Parma', 'wp-user-avatar'),
        'PV' => __('Pavia', 'wp-user-avatar'),
        'PG' => __('Perugia', 'wp-user-avatar'),
        'PU' => __('Pesaro e Urbino', 'wp-user-avatar'),
        'PE' => __('Pescara', 'wp-user-avatar'),
        'PC' => __('Piacenza', 'wp-user-avatar'),
        'PI' => __('Pisa', 'wp-user-avatar'),
        'PT' => __('Pistoia', 'wp-user-avatar'),
        'PN' => __('Pordenone', 'wp-user-avatar'),
        'PZ' => __('Potenza', 'wp-user-avatar'),
        'PO' => __('Prato', 'wp-user-avatar'),
        'RG' => __('Ragusa', 'wp-user-avatar'),
        'RA' => __('Ravenna', 'wp-user-avatar'),
        'RC' => __('Reggio Calabria', 'wp-user-avatar'),
        'RE' => __('Reggio Emilia', 'wp-user-avatar'),
        'RI' => __('Rieti', 'wp-user-avatar'),
        'RN' => __('Rimini', 'wp-user-avatar'),
        'RM' => __('Roma', 'wp-user-avatar'),
        'RO' => __('Rovigo', 'wp-user-avatar'),
        'SA' => __('Salerno', 'wp-user-avatar'),
        'SS' => __('Sassari', 'wp-user-avatar'),
        'SV' => __('Savona', 'wp-user-avatar'),
        'SI' => __('Siena', 'wp-user-avatar'),
        'SR' => __('Siracusa', 'wp-user-avatar'),
        'SO' => __('Sondrio', 'wp-user-avatar'),
        'SU' => __('Sud Sardegna', 'wp-user-avatar'),
        'TA' => __('Taranto', 'wp-user-avatar'),
        'TE' => __('Teramo', 'wp-user-avatar'),
        'TR' => __('Terni', 'wp-user-avatar'),
        'TO' => __('Torino', 'wp-user-avatar'),
        'TP' => __('Trapani', 'wp-user-avatar'),
        'TN' => __('Trento', 'wp-user-avatar'),
        'TV' => __('Treviso', 'wp-user-avatar'),
        'TS' => __('Trieste', 'wp-user-avatar'),
        'UD' => __('Udine', 'wp-user-avatar'),
        'VA' => __('Varese', 'wp-user-avatar'),
        'VE' => __('Venezia', 'wp-user-avatar'),
        'VB' => __('Verbano-Cusio-Ossola', 'wp-user-avatar'),
        'VC' => __('Vercelli', 'wp-user-avatar'),
        'VR' => __('Verona', 'wp-user-avatar'),
        'VV' => __('Vibo Valentia', 'wp-user-avatar'),
        'VI' => __('Vicenza', 'wp-user-avatar'),
        'VT' => __('Viterbo', 'wp-user-avatar'),
    ),
    'IL' => array(),
    'IM' => array(),
    'JM' => array( // Jamaican parishes.
        'JM-01' => __('Kingston', 'wp-user-avatar'),
        'JM-02' => __('Saint Andrew', 'wp-user-avatar'),
        'JM-03' => __('Saint Thomas', 'wp-user-avatar'),
        'JM-04' => __('Portland', 'wp-user-avatar'),
        'JM-05' => __('Saint Mary', 'wp-user-avatar'),
        'JM-06' => __('Saint Ann', 'wp-user-avatar'),
        'JM-07' => __('Trelawny', 'wp-user-avatar'),
        'JM-08' => __('Saint James', 'wp-user-avatar'),
        'JM-09' => __('Hanover', 'wp-user-avatar'),
        'JM-10' => __('Westmoreland', 'wp-user-avatar'),
        'JM-11' => __('Saint Elizabeth', 'wp-user-avatar'),
        'JM-12' => __('Manchester', 'wp-user-avatar'),
        'JM-13' => __('Clarendon', 'wp-user-avatar'),
        'JM-14' => __('Saint Catherine', 'wp-user-avatar'),
    ),

    /**
     * Japanese states.
     *
     * English notation of prefectures conform to the notation of Japan Post.
     * The suffix corresponds with the Japanese translation file.
     */
    'JP' => array(
        'JP01' => __('Hokkaido', 'wp-user-avatar'),
        'JP02' => __('Aomori', 'wp-user-avatar'),
        'JP03' => __('Iwate', 'wp-user-avatar'),
        'JP04' => __('Miyagi', 'wp-user-avatar'),
        'JP05' => __('Akita', 'wp-user-avatar'),
        'JP06' => __('Yamagata', 'wp-user-avatar'),
        'JP07' => __('Fukushima', 'wp-user-avatar'),
        'JP08' => __('Ibaraki', 'wp-user-avatar'),
        'JP09' => __('Tochigi', 'wp-user-avatar'),
        'JP10' => __('Gunma', 'wp-user-avatar'),
        'JP11' => __('Saitama', 'wp-user-avatar'),
        'JP12' => __('Chiba', 'wp-user-avatar'),
        'JP13' => __('Tokyo', 'wp-user-avatar'),
        'JP14' => __('Kanagawa', 'wp-user-avatar'),
        'JP15' => __('Niigata', 'wp-user-avatar'),
        'JP16' => __('Toyama', 'wp-user-avatar'),
        'JP17' => __('Ishikawa', 'wp-user-avatar'),
        'JP18' => __('Fukui', 'wp-user-avatar'),
        'JP19' => __('Yamanashi', 'wp-user-avatar'),
        'JP20' => __('Nagano', 'wp-user-avatar'),
        'JP21' => __('Gifu', 'wp-user-avatar'),
        'JP22' => __('Shizuoka', 'wp-user-avatar'),
        'JP23' => __('Aichi', 'wp-user-avatar'),
        'JP24' => __('Mie', 'wp-user-avatar'),
        'JP25' => __('Shiga', 'wp-user-avatar'),
        'JP26' => __('Kyoto', 'wp-user-avatar'),
        'JP27' => __('Osaka', 'wp-user-avatar'),
        'JP28' => __('Hyogo', 'wp-user-avatar'),
        'JP29' => __('Nara', 'wp-user-avatar'),
        'JP30' => __('Wakayama', 'wp-user-avatar'),
        'JP31' => __('Tottori', 'wp-user-avatar'),
        'JP32' => __('Shimane', 'wp-user-avatar'),
        'JP33' => __('Okayama', 'wp-user-avatar'),
        'JP34' => __('Hiroshima', 'wp-user-avatar'),
        'JP35' => __('Yamaguchi', 'wp-user-avatar'),
        'JP36' => __('Tokushima', 'wp-user-avatar'),
        'JP37' => __('Kagawa', 'wp-user-avatar'),
        'JP38' => __('Ehime', 'wp-user-avatar'),
        'JP39' => __('Kochi', 'wp-user-avatar'),
        'JP40' => __('Fukuoka', 'wp-user-avatar'),
        'JP41' => __('Saga', 'wp-user-avatar'),
        'JP42' => __('Nagasaki', 'wp-user-avatar'),
        'JP43' => __('Kumamoto', 'wp-user-avatar'),
        'JP44' => __('Oita', 'wp-user-avatar'),
        'JP45' => __('Miyazaki', 'wp-user-avatar'),
        'JP46' => __('Kagoshima', 'wp-user-avatar'),
        'JP47' => __('Okinawa', 'wp-user-avatar'),
    ),
    'KE' => array( // Kenyan counties.
        'KE01' => __('Baringo', 'wp-user-avatar'),
        'KE02' => __('Bomet', 'wp-user-avatar'),
        'KE03' => __('Bungoma', 'wp-user-avatar'),
        'KE04' => __('Busia', 'wp-user-avatar'),
        'KE05' => __('Elgeyo-Marakwet', 'wp-user-avatar'),
        'KE06' => __('Embu', 'wp-user-avatar'),
        'KE07' => __('Garissa', 'wp-user-avatar'),
        'KE08' => __('Homa Bay', 'wp-user-avatar'),
        'KE09' => __('Isiolo', 'wp-user-avatar'),
        'KE10' => __('Kajiado', 'wp-user-avatar'),
        'KE11' => __('Kakamega', 'wp-user-avatar'),
        'KE12' => __('Kericho', 'wp-user-avatar'),
        'KE13' => __('Kiambu', 'wp-user-avatar'),
        'KE14' => __('Kilifi', 'wp-user-avatar'),
        'KE15' => __('Kirinyaga', 'wp-user-avatar'),
        'KE16' => __('Kisii', 'wp-user-avatar'),
        'KE17' => __('Kisumu', 'wp-user-avatar'),
        'KE18' => __('Kitui', 'wp-user-avatar'),
        'KE19' => __('Kwale', 'wp-user-avatar'),
        'KE20' => __('Laikipia', 'wp-user-avatar'),
        'KE21' => __('Lamu', 'wp-user-avatar'),
        'KE22' => __('Machakos', 'wp-user-avatar'),
        'KE23' => __('Makueni', 'wp-user-avatar'),
        'KE24' => __('Mandera', 'wp-user-avatar'),
        'KE25' => __('Marsabit', 'wp-user-avatar'),
        'KE26' => __('Meru', 'wp-user-avatar'),
        'KE27' => __('Migori', 'wp-user-avatar'),
        'KE28' => __('Mombasa', 'wp-user-avatar'),
        'KE29' => __('Murang’a', 'wp-user-avatar'),
        'KE30' => __('Nairobi County', 'wp-user-avatar'),
        'KE31' => __('Nakuru', 'wp-user-avatar'),
        'KE32' => __('Nandi', 'wp-user-avatar'),
        'KE33' => __('Narok', 'wp-user-avatar'),
        'KE34' => __('Nyamira', 'wp-user-avatar'),
        'KE35' => __('Nyandarua', 'wp-user-avatar'),
        'KE36' => __('Nyeri', 'wp-user-avatar'),
        'KE37' => __('Samburu', 'wp-user-avatar'),
        'KE38' => __('Siaya', 'wp-user-avatar'),
        'KE39' => __('Taita-Taveta', 'wp-user-avatar'),
        'KE40' => __('Tana River', 'wp-user-avatar'),
        'KE41' => __('Tharaka-Nithi', 'wp-user-avatar'),
        'KE42' => __('Trans Nzoia', 'wp-user-avatar'),
        'KE43' => __('Turkana', 'wp-user-avatar'),
        'KE44' => __('Uasin Gishu', 'wp-user-avatar'),
        'KE45' => __('Vihiga', 'wp-user-avatar'),
        'KE46' => __('Wajir', 'wp-user-avatar'),
        'KE47' => __('West Pokot', 'wp-user-avatar'),
    ),
    'KN' => array( // Saint Kitts and Nevis parishes.
        'KNK'  => __('Saint Kitts', 'wp-user-avatar'),
        'KNN'  => __('Nevis', 'wp-user-avatar'),
        'KN01' => __('Christ Church Nichola Town', 'wp-user-avatar'),
        'KN02' => __('Saint Anne Sandy Point', 'wp-user-avatar'),
        'KN03' => __('Saint George Basseterre', 'wp-user-avatar'),
        'KN04' => __('Saint George Gingerland', 'wp-user-avatar'),
        'KN05' => __('Saint James Windward', 'wp-user-avatar'),
        'KN06' => __('Saint John Capisterre', 'wp-user-avatar'),
        'KN07' => __('Saint John Figtree', 'wp-user-avatar'),
        'KN08' => __('Saint Mary Cayon', 'wp-user-avatar'),
        'KN09' => __('Saint Paul Capisterre', 'wp-user-avatar'),
        'KN10' => __('Saint Paul Charlestown', 'wp-user-avatar'),
        'KN11' => __('Saint Peter Basseterre', 'wp-user-avatar'),
        'KN12' => __('Saint Thomas Lowland', 'wp-user-avatar'),
        'KN13' => __('Saint Thomas Middle Island', 'wp-user-avatar'),
        'KN15' => __('Trinity Palmetto Point', 'wp-user-avatar'),
    ),
    'KR' => array(),
    'KW' => array(),
    'LA' => array( // Laotian provinces.
        'AT' => __('Attapeu', 'wp-user-avatar'),
        'BK' => __('Bokeo', 'wp-user-avatar'),
        'BL' => __('Bolikhamsai', 'wp-user-avatar'),
        'CH' => __('Champasak', 'wp-user-avatar'),
        'HO' => __('Houaphanh', 'wp-user-avatar'),
        'KH' => __('Khammouane', 'wp-user-avatar'),
        'LM' => __('Luang Namtha', 'wp-user-avatar'),
        'LP' => __('Luang Prabang', 'wp-user-avatar'),
        'OU' => __('Oudomxay', 'wp-user-avatar'),
        'PH' => __('Phongsaly', 'wp-user-avatar'),
        'SL' => __('Salavan', 'wp-user-avatar'),
        'SV' => __('Savannakhet', 'wp-user-avatar'),
        'VI' => __('Vientiane Province', 'wp-user-avatar'),
        'VT' => __('Vientiane', 'wp-user-avatar'),
        'XA' => __('Sainyabuli', 'wp-user-avatar'),
        'XE' => __('Sekong', 'wp-user-avatar'),
        'XI' => __('Xiangkhouang', 'wp-user-avatar'),
        'XS' => __('Xaisomboun', 'wp-user-avatar'),
    ),
    'LB' => array(),
    'LI' => array(),
    'LR' => array( // Liberian provinces.
        'BM' => __('Bomi', 'wp-user-avatar'),
        'BN' => __('Bong', 'wp-user-avatar'),
        'GA' => __('Gbarpolu', 'wp-user-avatar'),
        'GB' => __('Grand Bassa', 'wp-user-avatar'),
        'GC' => __('Grand Cape Mount', 'wp-user-avatar'),
        'GG' => __('Grand Gedeh', 'wp-user-avatar'),
        'GK' => __('Grand Kru', 'wp-user-avatar'),
        'LO' => __('Lofa', 'wp-user-avatar'),
        'MA' => __('Margibi', 'wp-user-avatar'),
        'MY' => __('Maryland', 'wp-user-avatar'),
        'MO' => __('Montserrado', 'wp-user-avatar'),
        'NM' => __('Nimba', 'wp-user-avatar'),
        'RV' => __('Rivercess', 'wp-user-avatar'),
        'RG' => __('River Gee', 'wp-user-avatar'),
        'SN' => __('Sinoe', 'wp-user-avatar'),
    ),
    'LU' => array(),
    'MA' => array( // Moroccan regions.
        'maagd' => __('Agadir-Ida Ou Tanane', 'wp-user-avatar'),
        'maazi' => __('Azilal', 'wp-user-avatar'),
        'mabem' => __('Béni-Mellal', 'wp-user-avatar'),
        'maber' => __('Berkane', 'wp-user-avatar'),
        'mabes' => __('Ben Slimane', 'wp-user-avatar'),
        'mabod' => __('Boujdour', 'wp-user-avatar'),
        'mabom' => __('Boulemane', 'wp-user-avatar'),
        'mabrr' => __('Berrechid', 'wp-user-avatar'),
        'macas' => __('Casablanca', 'wp-user-avatar'),
        'mache' => __('Chefchaouen', 'wp-user-avatar'),
        'machi' => __('Chichaoua', 'wp-user-avatar'),
        'macht' => __('Chtouka Aït Baha', 'wp-user-avatar'),
        'madri' => __('Driouch', 'wp-user-avatar'),
        'maedi' => __('Essaouira', 'wp-user-avatar'),
        'maerr' => __('Errachidia', 'wp-user-avatar'),
        'mafah' => __('Fahs-Beni Makada', 'wp-user-avatar'),
        'mafes' => __('Fès-Dar-Dbibegh', 'wp-user-avatar'),
        'mafig' => __('Figuig', 'wp-user-avatar'),
        'mafqh' => __('Fquih Ben Salah', 'wp-user-avatar'),
        'mafes' => __('Fès-Dar-Dbibegh', 'wp-user-avatar'),
        'mague' => __('Guelmim', 'wp-user-avatar'),
        'maguf' => __('Guercif', 'wp-user-avatar'),
        'mahaj' => __('El Hajeb', 'wp-user-avatar'),
        'mahao' => __('Al Haouz', 'wp-user-avatar'),
        'mahoc' => __('Al Hoceïma', 'wp-user-avatar'),
        'maifr' => __('Ifrane', 'wp-user-avatar'),
        'maine' => __('Inezgane-Aït Melloul', 'wp-user-avatar'),
        'majdi' => __('El Jadida', 'wp-user-avatar'),
        'majra' => __('Jerada', 'wp-user-avatar'),
        'maken' => __('Kénitra', 'wp-user-avatar'),
        'makes' => __('Kelaat Sraghna', 'wp-user-avatar'),
        'makhe' => __('Khemisset', 'wp-user-avatar'),
        'makhn' => __('Khénifra', 'wp-user-avatar'),
        'makho' => __('Khouribga', 'wp-user-avatar'),
        'malaa' => __('Laâyoune', 'wp-user-avatar'),
        'malar' => __('Larache', 'wp-user-avatar'),
        'mamar' => __('Marrakech', 'wp-user-avatar'),
        'mamdf' => __('M’diq-Fnideq', 'wp-user-avatar'),
        'mamed' => __('Médiouna', 'wp-user-avatar'),
        'mamek' => __('Meknès', 'wp-user-avatar'),
        'mamid' => __('Midelt', 'wp-user-avatar'),
        'mammd' => __('Marrakech-Medina', 'wp-user-avatar'),
        'mammn' => __('Marrakech-Menara', 'wp-user-avatar'),
        'mamoh' => __('Mohammedia', 'wp-user-avatar'),
        'mamou' => __('Moulay Yacoub', 'wp-user-avatar'),
        'manad' => __('Nador', 'wp-user-avatar'),
        'manou' => __('Nouaceur', 'wp-user-avatar'),
        'maoua' => __('Ouarzazate', 'wp-user-avatar'),
        'maoud' => __('Oued Ed-Dahab', 'wp-user-avatar'),
        'maouj' => __('Oujda-Angad', 'wp-user-avatar'),
        'maouz' => __('Ouezzane', 'wp-user-avatar'),
        'marab' => __('Rabat', 'wp-user-avatar'),
        'mareh' => __('Rehamna', 'wp-user-avatar'),
        'masaf' => __('Safi', 'wp-user-avatar'),
        'masal' => __('Salé', 'wp-user-avatar'),
        'masef' => __('Sefrou', 'wp-user-avatar'),
        'maset' => __('Settat', 'wp-user-avatar'),
        'masib' => __('Sidi Bennour', 'wp-user-avatar'),
        'masif' => __('Sidi Ifni', 'wp-user-avatar'),
        'masik' => __('Sidi Kacem', 'wp-user-avatar'),
        'masil' => __('Sidi Slimane', 'wp-user-avatar'),
        'maskh' => __('Skhirat-Témara', 'wp-user-avatar'),
        'masyb' => __('Sidi Youssef Ben Ali', 'wp-user-avatar'),
        'mataf' => __('Tarfaya (EH-partial)', 'wp-user-avatar'),
        'matai' => __('Taourirt', 'wp-user-avatar'),
        'matao' => __('Taounate', 'wp-user-avatar'),
        'matar' => __('Taroudant', 'wp-user-avatar'),
        'matat' => __('Tata', 'wp-user-avatar'),
        'mataz' => __('Taza', 'wp-user-avatar'),
        'matet' => __('Tétouan', 'wp-user-avatar'),
        'matin' => __('Tinghir', 'wp-user-avatar'),
        'matiz' => __('Tiznit', 'wp-user-avatar'),
        'matng' => __('Tangier-Assilah', 'wp-user-avatar'),
        'matnt' => __('Tan-Tan', 'wp-user-avatar'),
        'mayus' => __('Youssoufia', 'wp-user-avatar'),
        'mazag' => __('Zagora', 'wp-user-avatar')
    ),
    'MD' => array( // Moldovan states.
        'C'  => __('Chișinău', 'wp-user-avatar'),
        'BL' => __('Bălți', 'wp-user-avatar'),
        'AN' => __('Anenii Noi', 'wp-user-avatar'),
        'BS' => __('Basarabeasca', 'wp-user-avatar'),
        'BR' => __('Briceni', 'wp-user-avatar'),
        'CH' => __('Cahul', 'wp-user-avatar'),
        'CT' => __('Cantemir', 'wp-user-avatar'),
        'CL' => __('Călărași', 'wp-user-avatar'),
        'CS' => __('Căușeni', 'wp-user-avatar'),
        'CM' => __('Cimișlia', 'wp-user-avatar'),
        'CR' => __('Criuleni', 'wp-user-avatar'),
        'DN' => __('Dondușeni', 'wp-user-avatar'),
        'DR' => __('Drochia', 'wp-user-avatar'),
        'DB' => __('Dubăsari', 'wp-user-avatar'),
        'ED' => __('Edineț', 'wp-user-avatar'),
        'FL' => __('Fălești', 'wp-user-avatar'),
        'FR' => __('Florești', 'wp-user-avatar'),
        'GE' => __('UTA Găgăuzia', 'wp-user-avatar'),
        'GL' => __('Glodeni', 'wp-user-avatar'),
        'HN' => __('Hîncești', 'wp-user-avatar'),
        'IL' => __('Ialoveni', 'wp-user-avatar'),
        'LV' => __('Leova', 'wp-user-avatar'),
        'NS' => __('Nisporeni', 'wp-user-avatar'),
        'OC' => __('Ocnița', 'wp-user-avatar'),
        'OR' => __('Orhei', 'wp-user-avatar'),
        'RZ' => __('Rezina', 'wp-user-avatar'),
        'RS' => __('Rîșcani', 'wp-user-avatar'),
        'SG' => __('Sîngerei', 'wp-user-avatar'),
        'SR' => __('Soroca', 'wp-user-avatar'),
        'ST' => __('Strășeni', 'wp-user-avatar'),
        'SD' => __('Șoldănești', 'wp-user-avatar'),
        'SV' => __('Ștefan Vodă', 'wp-user-avatar'),
        'TR' => __('Taraclia', 'wp-user-avatar'),
        'TL' => __('Telenești', 'wp-user-avatar'),
        'UN' => __('Ungheni', 'wp-user-avatar'),
    ),
    'MF' => array(),
    'MQ' => array(),
    'MT' => array(),
    'MX' => array( // Mexican states.
        'DF' => __('Ciudad de México', 'wp-user-avatar'),
        'JA' => __('Jalisco', 'wp-user-avatar'),
        'NL' => __('Nuevo León', 'wp-user-avatar'),
        'AG' => __('Aguascalientes', 'wp-user-avatar'),
        'BC' => __('Baja California', 'wp-user-avatar'),
        'BS' => __('Baja California Sur', 'wp-user-avatar'),
        'CM' => __('Campeche', 'wp-user-avatar'),
        'CS' => __('Chiapas', 'wp-user-avatar'),
        'CH' => __('Chihuahua', 'wp-user-avatar'),
        'CO' => __('Coahuila', 'wp-user-avatar'),
        'CL' => __('Colima', 'wp-user-avatar'),
        'DG' => __('Durango', 'wp-user-avatar'),
        'GT' => __('Guanajuato', 'wp-user-avatar'),
        'GR' => __('Guerrero', 'wp-user-avatar'),
        'HG' => __('Hidalgo', 'wp-user-avatar'),
        'MX' => __('Estado de México', 'wp-user-avatar'),
        'MI' => __('Michoacán', 'wp-user-avatar'),
        'MO' => __('Morelos', 'wp-user-avatar'),
        'NA' => __('Nayarit', 'wp-user-avatar'),
        'OA' => __('Oaxaca', 'wp-user-avatar'),
        'PU' => __('Puebla', 'wp-user-avatar'),
        'QT' => __('Querétaro', 'wp-user-avatar'),
        'QR' => __('Quintana Roo', 'wp-user-avatar'),
        'SL' => __('San Luis Potosí', 'wp-user-avatar'),
        'SI' => __('Sinaloa', 'wp-user-avatar'),
        'SO' => __('Sonora', 'wp-user-avatar'),
        'TB' => __('Tabasco', 'wp-user-avatar'),
        'TM' => __('Tamaulipas', 'wp-user-avatar'),
        'TL' => __('Tlaxcala', 'wp-user-avatar'),
        'VE' => __('Veracruz', 'wp-user-avatar'),
        'YU' => __('Yucatán', 'wp-user-avatar'),
        'ZA' => __('Zacatecas', 'wp-user-avatar'),
    ),
    'MY' => array( // Malaysian states.
        'JHR' => __('Johor', 'wp-user-avatar'),
        'KDH' => __('Kedah', 'wp-user-avatar'),
        'KTN' => __('Kelantan', 'wp-user-avatar'),
        'LBN' => __('Labuan', 'wp-user-avatar'),
        'MLK' => __('Malacca (Melaka)', 'wp-user-avatar'),
        'NSN' => __('Negeri Sembilan', 'wp-user-avatar'),
        'PHG' => __('Pahang', 'wp-user-avatar'),
        'PNG' => __('Penang (Pulau Pinang)', 'wp-user-avatar'),
        'PRK' => __('Perak', 'wp-user-avatar'),
        'PLS' => __('Perlis', 'wp-user-avatar'),
        'SBH' => __('Sabah', 'wp-user-avatar'),
        'SWK' => __('Sarawak', 'wp-user-avatar'),
        'SGR' => __('Selangor', 'wp-user-avatar'),
        'TRG' => __('Terengganu', 'wp-user-avatar'),
        'PJY' => __('Putrajaya', 'wp-user-avatar'),
        'KUL' => __('Kuala Lumpur', 'wp-user-avatar'),
    ),
    'MZ' => array( // Mozambican provinces.
        'MZP'   => __('Cabo Delgado', 'wp-user-avatar'),
        'MZG'   => __('Gaza', 'wp-user-avatar'),
        'MZI'   => __('Inhambane', 'wp-user-avatar'),
        'MZB'   => __('Manica', 'wp-user-avatar'),
        'MZL'   => __('Maputo Province', 'wp-user-avatar'),
        'MZMPM' => __('Maputo', 'wp-user-avatar'),
        'MZN'   => __('Nampula', 'wp-user-avatar'),
        'MZA'   => __('Niassa', 'wp-user-avatar'),
        'MZS'   => __('Sofala', 'wp-user-avatar'),
        'MZT'   => __('Tete', 'wp-user-avatar'),
        'MZQ'   => __('Zambézia', 'wp-user-avatar'),
    ),
    'NA' => array( // Namibian regions.
        'ER' => __('Erongo', 'wp-user-avatar'),
        'HA' => __('Hardap', 'wp-user-avatar'),
        'KA' => __('Karas', 'wp-user-avatar'),
        'KE' => __('Kavango East', 'wp-user-avatar'),
        'KW' => __('Kavango West', 'wp-user-avatar'),
        'KH' => __('Khomas', 'wp-user-avatar'),
        'KU' => __('Kunene', 'wp-user-avatar'),
        'OW' => __('Ohangwena', 'wp-user-avatar'),
        'OH' => __('Omaheke', 'wp-user-avatar'),
        'OS' => __('Omusati', 'wp-user-avatar'),
        'ON' => __('Oshana', 'wp-user-avatar'),
        'OT' => __('Oshikoto', 'wp-user-avatar'),
        'OD' => __('Otjozondjupa', 'wp-user-avatar'),
        'CA' => __('Zambezi', 'wp-user-avatar'),
    ),
    'NG' => array( // Nigerian provinces.
        'AB' => __('Abia', 'wp-user-avatar'),
        'FC' => __('Abuja', 'wp-user-avatar'),
        'AD' => __('Adamawa', 'wp-user-avatar'),
        'AK' => __('Akwa Ibom', 'wp-user-avatar'),
        'AN' => __('Anambra', 'wp-user-avatar'),
        'BA' => __('Bauchi', 'wp-user-avatar'),
        'BY' => __('Bayelsa', 'wp-user-avatar'),
        'BE' => __('Benue', 'wp-user-avatar'),
        'BO' => __('Borno', 'wp-user-avatar'),
        'CR' => __('Cross River', 'wp-user-avatar'),
        'DE' => __('Delta', 'wp-user-avatar'),
        'EB' => __('Ebonyi', 'wp-user-avatar'),
        'ED' => __('Edo', 'wp-user-avatar'),
        'EK' => __('Ekiti', 'wp-user-avatar'),
        'EN' => __('Enugu', 'wp-user-avatar'),
        'GO' => __('Gombe', 'wp-user-avatar'),
        'IM' => __('Imo', 'wp-user-avatar'),
        'JI' => __('Jigawa', 'wp-user-avatar'),
        'KD' => __('Kaduna', 'wp-user-avatar'),
        'KN' => __('Kano', 'wp-user-avatar'),
        'KT' => __('Katsina', 'wp-user-avatar'),
        'KE' => __('Kebbi', 'wp-user-avatar'),
        'KO' => __('Kogi', 'wp-user-avatar'),
        'KW' => __('Kwara', 'wp-user-avatar'),
        'LA' => __('Lagos', 'wp-user-avatar'),
        'NA' => __('Nasarawa', 'wp-user-avatar'),
        'NI' => __('Niger', 'wp-user-avatar'),
        'OG' => __('Ogun', 'wp-user-avatar'),
        'ON' => __('Ondo', 'wp-user-avatar'),
        'OS' => __('Osun', 'wp-user-avatar'),
        'OY' => __('Oyo', 'wp-user-avatar'),
        'PL' => __('Plateau', 'wp-user-avatar'),
        'RI' => __('Rivers', 'wp-user-avatar'),
        'SO' => __('Sokoto', 'wp-user-avatar'),
        'TA' => __('Taraba', 'wp-user-avatar'),
        'YO' => __('Yobe', 'wp-user-avatar'),
        'ZA' => __('Zamfara', 'wp-user-avatar'),
    ),
    'NL' => array(),
    'NO' => array(),
    'NP' => array( // Nepalese zones.
        'BAG' => __('Bagmati', 'wp-user-avatar'),
        'BHE' => __('Bheri', 'wp-user-avatar'),
        'DHA' => __('Dhaulagiri', 'wp-user-avatar'),
        'GAN' => __('Gandaki', 'wp-user-avatar'),
        'JAN' => __('Janakpur', 'wp-user-avatar'),
        'KAR' => __('Karnali', 'wp-user-avatar'),
        'KOS' => __('Koshi', 'wp-user-avatar'),
        'LUM' => __('Lumbini', 'wp-user-avatar'),
        'MAH' => __('Mahakali', 'wp-user-avatar'),
        'MEC' => __('Mechi', 'wp-user-avatar'),
        'NAR' => __('Narayani', 'wp-user-avatar'),
        'RAP' => __('Rapti', 'wp-user-avatar'),
        'SAG' => __('Sagarmatha', 'wp-user-avatar'),
        'SET' => __('Seti', 'wp-user-avatar'),
    ),
    'NI' => array( // Nicaraguan states.
        'NI-AN' => __('Atlántico Norte', 'wp-user-avatar'),
        'NI-AS' => __('Atlántico Sur', 'wp-user-avatar'),
        'NI-BO' => __('Boaco', 'wp-user-avatar'),
        'NI-CA' => __('Carazo', 'wp-user-avatar'),
        'NI-CI' => __('Chinandega', 'wp-user-avatar'),
        'NI-CO' => __('Chontales', 'wp-user-avatar'),
        'NI-ES' => __('Estelí', 'wp-user-avatar'),
        'NI-GR' => __('Granada', 'wp-user-avatar'),
        'NI-JI' => __('Jinotega', 'wp-user-avatar'),
        'NI-LE' => __('León', 'wp-user-avatar'),
        'NI-MD' => __('Madriz', 'wp-user-avatar'),
        'NI-MN' => __('Managua', 'wp-user-avatar'),
        'NI-MS' => __('Masaya', 'wp-user-avatar'),
        'NI-MT' => __('Matagalpa', 'wp-user-avatar'),
        'NI-NS' => __('Nueva Segovia', 'wp-user-avatar'),
        'NI-RI' => __('Rivas', 'wp-user-avatar'),
        'NI-SJ' => __('Río San Juan', 'wp-user-avatar'),
    ),
    'NZ' => array( // New Zealand states.
        'NTL' => __('Northland', 'wp-user-avatar'),
        'AUK' => __('Auckland', 'wp-user-avatar'),
        'WKO' => __('Waikato', 'wp-user-avatar'),
        'BOP' => __('Bay of Plenty', 'wp-user-avatar'),
        'TKI' => __('Taranaki', 'wp-user-avatar'),
        'GIS' => __('Gisborne', 'wp-user-avatar'),
        'HKB' => __('Hawke’s Bay', 'wp-user-avatar'),
        'MWT' => __('Manawatu-Wanganui', 'wp-user-avatar'),
        'WGN' => __('Wellington', 'wp-user-avatar'),
        'NSN' => __('Nelson', 'wp-user-avatar'),
        'MBH' => __('Marlborough', 'wp-user-avatar'),
        'TAS' => __('Tasman', 'wp-user-avatar'),
        'WTC' => __('West Coast', 'wp-user-avatar'),
        'CAN' => __('Canterbury', 'wp-user-avatar'),
        'OTA' => __('Otago', 'wp-user-avatar'),
        'STL' => __('Southland', 'wp-user-avatar'),
    ),
    'PA' => array( // Panamanian states.
        'PA-1'  => __('Bocas del Toro', 'wp-user-avatar'),
        'PA-2'  => __('Coclé', 'wp-user-avatar'),
        'PA-3'  => __('Colón', 'wp-user-avatar'),
        'PA-4'  => __('Chiriquí', 'wp-user-avatar'),
        'PA-5'  => __('Darién', 'wp-user-avatar'),
        'PA-6'  => __('Herrera', 'wp-user-avatar'),
        'PA-7'  => __('Los Santos', 'wp-user-avatar'),
        'PA-8'  => __('Panamá', 'wp-user-avatar'),
        'PA-9'  => __('Veraguas', 'wp-user-avatar'),
        'PA-10' => __('West Panamá', 'wp-user-avatar'),
        'PA-EM' => __('Emberá', 'wp-user-avatar'),
        'PA-KY' => __('Guna Yala', 'wp-user-avatar'),
        'PA-NB' => __('Ngöbe-Buglé', 'wp-user-avatar'),
    ),
    'PE' => array( // Peruvian states.
        'CAL' => __('El Callao', 'wp-user-avatar'),
        'LMA' => __('Municipalidad Metropolitana de Lima', 'wp-user-avatar'),
        'AMA' => __('Amazonas', 'wp-user-avatar'),
        'ANC' => __('Ancash', 'wp-user-avatar'),
        'APU' => __('Apurímac', 'wp-user-avatar'),
        'ARE' => __('Arequipa', 'wp-user-avatar'),
        'AYA' => __('Ayacucho', 'wp-user-avatar'),
        'CAJ' => __('Cajamarca', 'wp-user-avatar'),
        'CUS' => __('Cusco', 'wp-user-avatar'),
        'HUV' => __('Huancavelica', 'wp-user-avatar'),
        'HUC' => __('Huánuco', 'wp-user-avatar'),
        'ICA' => __('Ica', 'wp-user-avatar'),
        'JUN' => __('Junín', 'wp-user-avatar'),
        'LAL' => __('La Libertad', 'wp-user-avatar'),
        'LAM' => __('Lambayeque', 'wp-user-avatar'),
        'LIM' => __('Lima', 'wp-user-avatar'),
        'LOR' => __('Loreto', 'wp-user-avatar'),
        'MDD' => __('Madre de Dios', 'wp-user-avatar'),
        'MOQ' => __('Moquegua', 'wp-user-avatar'),
        'PAS' => __('Pasco', 'wp-user-avatar'),
        'PIU' => __('Piura', 'wp-user-avatar'),
        'PUN' => __('Puno', 'wp-user-avatar'),
        'SAM' => __('San Martín', 'wp-user-avatar'),
        'TAC' => __('Tacna', 'wp-user-avatar'),
        'TUM' => __('Tumbes', 'wp-user-avatar'),
        'UCA' => __('Ucayali', 'wp-user-avatar'),
    ),
    'PH' => array( // Philippine provinces.
        'ABR' => __('Abra', 'wp-user-avatar'),
        'AGN' => __('Agusan del Norte', 'wp-user-avatar'),
        'AGS' => __('Agusan del Sur', 'wp-user-avatar'),
        'AKL' => __('Aklan', 'wp-user-avatar'),
        'ALB' => __('Albay', 'wp-user-avatar'),
        'ANT' => __('Antique', 'wp-user-avatar'),
        'APA' => __('Apayao', 'wp-user-avatar'),
        'AUR' => __('Aurora', 'wp-user-avatar'),
        'BAS' => __('Basilan', 'wp-user-avatar'),
        'BAN' => __('Bataan', 'wp-user-avatar'),
        'BTN' => __('Batanes', 'wp-user-avatar'),
        'BTG' => __('Batangas', 'wp-user-avatar'),
        'BEN' => __('Benguet', 'wp-user-avatar'),
        'BIL' => __('Biliran', 'wp-user-avatar'),
        'BOH' => __('Bohol', 'wp-user-avatar'),
        'BUK' => __('Bukidnon', 'wp-user-avatar'),
        'BUL' => __('Bulacan', 'wp-user-avatar'),
        'CAG' => __('Cagayan', 'wp-user-avatar'),
        'CAN' => __('Camarines Norte', 'wp-user-avatar'),
        'CAS' => __('Camarines Sur', 'wp-user-avatar'),
        'CAM' => __('Camiguin', 'wp-user-avatar'),
        'CAP' => __('Capiz', 'wp-user-avatar'),
        'CAT' => __('Catanduanes', 'wp-user-avatar'),
        'CAV' => __('Cavite', 'wp-user-avatar'),
        'CEB' => __('Cebu', 'wp-user-avatar'),
        'COM' => __('Compostela Valley', 'wp-user-avatar'),
        'NCO' => __('Cotabato', 'wp-user-avatar'),
        'DAV' => __('Davao del Norte', 'wp-user-avatar'),
        'DAS' => __('Davao del Sur', 'wp-user-avatar'),
        'DAC' => __('Davao Occidental', 'wp-user-avatar'),
        'DAO' => __('Davao Oriental', 'wp-user-avatar'),
        'DIN' => __('Dinagat Islands', 'wp-user-avatar'),
        'EAS' => __('Eastern Samar', 'wp-user-avatar'),
        'GUI' => __('Guimaras', 'wp-user-avatar'),
        'IFU' => __('Ifugao', 'wp-user-avatar'),
        'ILN' => __('Ilocos Norte', 'wp-user-avatar'),
        'ILS' => __('Ilocos Sur', 'wp-user-avatar'),
        'ILI' => __('Iloilo', 'wp-user-avatar'),
        'ISA' => __('Isabela', 'wp-user-avatar'),
        'KAL' => __('Kalinga', 'wp-user-avatar'),
        'LUN' => __('La Union', 'wp-user-avatar'),
        'LAG' => __('Laguna', 'wp-user-avatar'),
        'LAN' => __('Lanao del Norte', 'wp-user-avatar'),
        'LAS' => __('Lanao del Sur', 'wp-user-avatar'),
        'LEY' => __('Leyte', 'wp-user-avatar'),
        'MAG' => __('Maguindanao', 'wp-user-avatar'),
        'MAD' => __('Marinduque', 'wp-user-avatar'),
        'MAS' => __('Masbate', 'wp-user-avatar'),
        'MSC' => __('Misamis Occidental', 'wp-user-avatar'),
        'MSR' => __('Misamis Oriental', 'wp-user-avatar'),
        'MOU' => __('Mountain Province', 'wp-user-avatar'),
        'NEC' => __('Negros Occidental', 'wp-user-avatar'),
        'NER' => __('Negros Oriental', 'wp-user-avatar'),
        'NSA' => __('Northern Samar', 'wp-user-avatar'),
        'NUE' => __('Nueva Ecija', 'wp-user-avatar'),
        'NUV' => __('Nueva Vizcaya', 'wp-user-avatar'),
        'MDC' => __('Occidental Mindoro', 'wp-user-avatar'),
        'MDR' => __('Oriental Mindoro', 'wp-user-avatar'),
        'PLW' => __('Palawan', 'wp-user-avatar'),
        'PAM' => __('Pampanga', 'wp-user-avatar'),
        'PAN' => __('Pangasinan', 'wp-user-avatar'),
        'QUE' => __('Quezon', 'wp-user-avatar'),
        'QUI' => __('Quirino', 'wp-user-avatar'),
        'RIZ' => __('Rizal', 'wp-user-avatar'),
        'ROM' => __('Romblon', 'wp-user-avatar'),
        'WSA' => __('Samar', 'wp-user-avatar'),
        'SAR' => __('Sarangani', 'wp-user-avatar'),
        'SIQ' => __('Siquijor', 'wp-user-avatar'),
        'SOR' => __('Sorsogon', 'wp-user-avatar'),
        'SCO' => __('South Cotabato', 'wp-user-avatar'),
        'SLE' => __('Southern Leyte', 'wp-user-avatar'),
        'SUK' => __('Sultan Kudarat', 'wp-user-avatar'),
        'SLU' => __('Sulu', 'wp-user-avatar'),
        'SUN' => __('Surigao del Norte', 'wp-user-avatar'),
        'SUR' => __('Surigao del Sur', 'wp-user-avatar'),
        'TAR' => __('Tarlac', 'wp-user-avatar'),
        'TAW' => __('Tawi-Tawi', 'wp-user-avatar'),
        'ZMB' => __('Zambales', 'wp-user-avatar'),
        'ZAN' => __('Zamboanga del Norte', 'wp-user-avatar'),
        'ZAS' => __('Zamboanga del Sur', 'wp-user-avatar'),
        'ZSI' => __('Zamboanga Sibugay', 'wp-user-avatar'),
        '00'  => __('Metro Manila', 'wp-user-avatar'),
    ),
    'PK' => array( // Pakistani states.
        'JK' => __('Azad Kashmir', 'wp-user-avatar'),
        'BA' => __('Balochistan', 'wp-user-avatar'),
        'TA' => __('FATA', 'wp-user-avatar'),
        'GB' => __('Gilgit Baltistan', 'wp-user-avatar'),
        'IS' => __('Islamabad Capital Territory', 'wp-user-avatar'),
        'KP' => __('Khyber Pakhtunkhwa', 'wp-user-avatar'),
        'PB' => __('Punjab', 'wp-user-avatar'),
        'SD' => __('Sindh', 'wp-user-avatar'),
    ),
    'PL' => array(),
    'PR' => array(),
    'PT' => array(),
    'PY' => array( // Paraguayan states.
        'PY-ASU' => __('Asunción', 'wp-user-avatar'),
        'PY-1'   => __('Concepción', 'wp-user-avatar'),
        'PY-2'   => __('San Pedro', 'wp-user-avatar'),
        'PY-3'   => __('Cordillera', 'wp-user-avatar'),
        'PY-4'   => __('Guairá', 'wp-user-avatar'),
        'PY-5'   => __('Caaguazú', 'wp-user-avatar'),
        'PY-6'   => __('Caazapá', 'wp-user-avatar'),
        'PY-7'   => __('Itapúa', 'wp-user-avatar'),
        'PY-8'   => __('Misiones', 'wp-user-avatar'),
        'PY-9'   => __('Paraguarí', 'wp-user-avatar'),
        'PY-10'  => __('Alto Paraná', 'wp-user-avatar'),
        'PY-11'  => __('Central', 'wp-user-avatar'),
        'PY-12'  => __('Ñeembucú', 'wp-user-avatar'),
        'PY-13'  => __('Amambay', 'wp-user-avatar'),
        'PY-14'  => __('Canindeyú', 'wp-user-avatar'),
        'PY-15'  => __('Presidente Hayes', 'wp-user-avatar'),
        'PY-16'  => __('Alto Paraguay', 'wp-user-avatar'),
        'PY-17'  => __('Boquerón', 'wp-user-avatar'),
    ),
    'RE' => array(),
    'RO' => array( // Romanian states.
        'AB' => __('Alba', 'wp-user-avatar'),
        'AR' => __('Arad', 'wp-user-avatar'),
        'AG' => __('Argeș', 'wp-user-avatar'),
        'BC' => __('Bacău', 'wp-user-avatar'),
        'BH' => __('Bihor', 'wp-user-avatar'),
        'BN' => __('Bistrița-Năsăud', 'wp-user-avatar'),
        'BT' => __('Botoșani', 'wp-user-avatar'),
        'BR' => __('Brăila', 'wp-user-avatar'),
        'BV' => __('Brașov', 'wp-user-avatar'),
        'B'  => __('București', 'wp-user-avatar'),
        'BZ' => __('Buzău', 'wp-user-avatar'),
        'CL' => __('Călărași', 'wp-user-avatar'),
        'CS' => __('Caraș-Severin', 'wp-user-avatar'),
        'CJ' => __('Cluj', 'wp-user-avatar'),
        'CT' => __('Constanța', 'wp-user-avatar'),
        'CV' => __('Covasna', 'wp-user-avatar'),
        'DB' => __('Dâmbovița', 'wp-user-avatar'),
        'DJ' => __('Dolj', 'wp-user-avatar'),
        'GL' => __('Galați', 'wp-user-avatar'),
        'GR' => __('Giurgiu', 'wp-user-avatar'),
        'GJ' => __('Gorj', 'wp-user-avatar'),
        'HR' => __('Harghita', 'wp-user-avatar'),
        'HD' => __('Hunedoara', 'wp-user-avatar'),
        'IL' => __('Ialomița', 'wp-user-avatar'),
        'IS' => __('Iași', 'wp-user-avatar'),
        'IF' => __('Ilfov', 'wp-user-avatar'),
        'MM' => __('Maramureș', 'wp-user-avatar'),
        'MH' => __('Mehedinți', 'wp-user-avatar'),
        'MS' => __('Mureș', 'wp-user-avatar'),
        'NT' => __('Neamț', 'wp-user-avatar'),
        'OT' => __('Olt', 'wp-user-avatar'),
        'PH' => __('Prahova', 'wp-user-avatar'),
        'SJ' => __('Sălaj', 'wp-user-avatar'),
        'SM' => __('Satu Mare', 'wp-user-avatar'),
        'SB' => __('Sibiu', 'wp-user-avatar'),
        'SV' => __('Suceava', 'wp-user-avatar'),
        'TR' => __('Teleorman', 'wp-user-avatar'),
        'TM' => __('Timiș', 'wp-user-avatar'),
        'TL' => __('Tulcea', 'wp-user-avatar'),
        'VL' => __('Vâlcea', 'wp-user-avatar'),
        'VS' => __('Vaslui', 'wp-user-avatar'),
        'VN' => __('Vrancea', 'wp-user-avatar'),
    ),
    'SN' => array( // Regions of Senegal. Ref: https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L4801.
        'SNDB' => __('Diourbel', 'wp-user-avatar'),
        'SNDK' => __('Dakar', 'wp-user-avatar'),
        'SNFK' => __('Fatick', 'wp-user-avatar'),
        'SNKA' => __('Kaffrine', 'wp-user-avatar'),
        'SNKD' => __('Kolda', 'wp-user-avatar'),
        'SNKE' => __('Kédougou', 'wp-user-avatar'),
        'SNKL' => __('Kaolack', 'wp-user-avatar'),
        'SNLG' => __('Louga', 'wp-user-avatar'),
        'SNMT' => __('Matam', 'wp-user-avatar'),
        'SNSE' => __('Sédhiou', 'wp-user-avatar'),
        'SNSL' => __('Saint-Louis', 'wp-user-avatar'),
        'SNTC' => __('Tambacounda', 'wp-user-avatar'),
        'SNTH' => __('Thiès', 'wp-user-avatar'),
        'SNZG' => __('Ziguinchor', 'wp-user-avatar'),
    ),
    'SG' => array(),
    'SK' => array(),
    'SI' => array(),
    'SV' => array( // Salvadoran states.
        'SV-AH' => __('Ahuachapán', 'wp-user-avatar'),
        'SV-CA' => __('Cabañas', 'wp-user-avatar'),
        'SV-CH' => __('Chalatenango', 'wp-user-avatar'),
        'SV-CU' => __('Cuscatlán', 'wp-user-avatar'),
        'SV-LI' => __('La Libertad', 'wp-user-avatar'),
        'SV-MO' => __('Morazán', 'wp-user-avatar'),
        'SV-PA' => __('La Paz', 'wp-user-avatar'),
        'SV-SA' => __('Santa Ana', 'wp-user-avatar'),
        'SV-SM' => __('San Miguel', 'wp-user-avatar'),
        'SV-SO' => __('Sonsonate', 'wp-user-avatar'),
        'SV-SS' => __('San Salvador', 'wp-user-avatar'),
        'SV-SV' => __('San Vicente', 'wp-user-avatar'),
        'SV-UN' => __('La Unión', 'wp-user-avatar'),
        'SV-US' => __('Usulután', 'wp-user-avatar'),
    ),
    'TH' => array( // Thai states.
        'TH-37' => __('Amnat Charoen', 'wp-user-avatar'),
        'TH-15' => __('Ang Thong', 'wp-user-avatar'),
        'TH-14' => __('Ayutthaya', 'wp-user-avatar'),
        'TH-10' => __('Bangkok', 'wp-user-avatar'),
        'TH-38' => __('Bueng Kan', 'wp-user-avatar'),
        'TH-31' => __('Buri Ram', 'wp-user-avatar'),
        'TH-24' => __('Chachoengsao', 'wp-user-avatar'),
        'TH-18' => __('Chai Nat', 'wp-user-avatar'),
        'TH-36' => __('Chaiyaphum', 'wp-user-avatar'),
        'TH-22' => __('Chanthaburi', 'wp-user-avatar'),
        'TH-50' => __('Chiang Mai', 'wp-user-avatar'),
        'TH-57' => __('Chiang Rai', 'wp-user-avatar'),
        'TH-20' => __('Chonburi', 'wp-user-avatar'),
        'TH-86' => __('Chumphon', 'wp-user-avatar'),
        'TH-46' => __('Kalasin', 'wp-user-avatar'),
        'TH-62' => __('Kamphaeng Phet', 'wp-user-avatar'),
        'TH-71' => __('Kanchanaburi', 'wp-user-avatar'),
        'TH-40' => __('Khon Kaen', 'wp-user-avatar'),
        'TH-81' => __('Krabi', 'wp-user-avatar'),
        'TH-52' => __('Lampang', 'wp-user-avatar'),
        'TH-51' => __('Lamphun', 'wp-user-avatar'),
        'TH-42' => __('Loei', 'wp-user-avatar'),
        'TH-16' => __('Lopburi', 'wp-user-avatar'),
        'TH-58' => __('Mae Hong Son', 'wp-user-avatar'),
        'TH-44' => __('Maha Sarakham', 'wp-user-avatar'),
        'TH-49' => __('Mukdahan', 'wp-user-avatar'),
        'TH-26' => __('Nakhon Nayok', 'wp-user-avatar'),
        'TH-73' => __('Nakhon Pathom', 'wp-user-avatar'),
        'TH-48' => __('Nakhon Phanom', 'wp-user-avatar'),
        'TH-30' => __('Nakhon Ratchasima', 'wp-user-avatar'),
        'TH-60' => __('Nakhon Sawan', 'wp-user-avatar'),
        'TH-80' => __('Nakhon Si Thammarat', 'wp-user-avatar'),
        'TH-55' => __('Nan', 'wp-user-avatar'),
        'TH-96' => __('Narathiwat', 'wp-user-avatar'),
        'TH-39' => __('Nong Bua Lam Phu', 'wp-user-avatar'),
        'TH-43' => __('Nong Khai', 'wp-user-avatar'),
        'TH-12' => __('Nonthaburi', 'wp-user-avatar'),
        'TH-13' => __('Pathum Thani', 'wp-user-avatar'),
        'TH-94' => __('Pattani', 'wp-user-avatar'),
        'TH-82' => __('Phang Nga', 'wp-user-avatar'),
        'TH-93' => __('Phatthalung', 'wp-user-avatar'),
        'TH-56' => __('Phayao', 'wp-user-avatar'),
        'TH-67' => __('Phetchabun', 'wp-user-avatar'),
        'TH-76' => __('Phetchaburi', 'wp-user-avatar'),
        'TH-66' => __('Phichit', 'wp-user-avatar'),
        'TH-65' => __('Phitsanulok', 'wp-user-avatar'),
        'TH-54' => __('Phrae', 'wp-user-avatar'),
        'TH-83' => __('Phuket', 'wp-user-avatar'),
        'TH-25' => __('Prachin Buri', 'wp-user-avatar'),
        'TH-77' => __('Prachuap Khiri Khan', 'wp-user-avatar'),
        'TH-85' => __('Ranong', 'wp-user-avatar'),
        'TH-70' => __('Ratchaburi', 'wp-user-avatar'),
        'TH-21' => __('Rayong', 'wp-user-avatar'),
        'TH-45' => __('Roi Et', 'wp-user-avatar'),
        'TH-27' => __('Sa Kaeo', 'wp-user-avatar'),
        'TH-47' => __('Sakon Nakhon', 'wp-user-avatar'),
        'TH-11' => __('Samut Prakan', 'wp-user-avatar'),
        'TH-74' => __('Samut Sakhon', 'wp-user-avatar'),
        'TH-75' => __('Samut Songkhram', 'wp-user-avatar'),
        'TH-19' => __('Saraburi', 'wp-user-avatar'),
        'TH-91' => __('Satun', 'wp-user-avatar'),
        'TH-17' => __('Sing Buri', 'wp-user-avatar'),
        'TH-33' => __('Sisaket', 'wp-user-avatar'),
        'TH-90' => __('Songkhla', 'wp-user-avatar'),
        'TH-64' => __('Sukhothai', 'wp-user-avatar'),
        'TH-72' => __('Suphan Buri', 'wp-user-avatar'),
        'TH-84' => __('Surat Thani', 'wp-user-avatar'),
        'TH-32' => __('Surin', 'wp-user-avatar'),
        'TH-63' => __('Tak', 'wp-user-avatar'),
        'TH-92' => __('Trang', 'wp-user-avatar'),
        'TH-23' => __('Trat', 'wp-user-avatar'),
        'TH-34' => __('Ubon Ratchathani', 'wp-user-avatar'),
        'TH-41' => __('Udon Thani', 'wp-user-avatar'),
        'TH-61' => __('Uthai Thani', 'wp-user-avatar'),
        'TH-53' => __('Uttaradit', 'wp-user-avatar'),
        'TH-95' => __('Yala', 'wp-user-avatar'),
        'TH-35' => __('Yasothon', 'wp-user-avatar'),
    ),
    'TR' => array( // Turkish states.
        'TR01' => __('Adana', 'wp-user-avatar'),
        'TR02' => __('Adıyaman', 'wp-user-avatar'),
        'TR03' => __('Afyon', 'wp-user-avatar'),
        'TR04' => __('Ağrı', 'wp-user-avatar'),
        'TR05' => __('Amasya', 'wp-user-avatar'),
        'TR06' => __('Ankara', 'wp-user-avatar'),
        'TR07' => __('Antalya', 'wp-user-avatar'),
        'TR08' => __('Artvin', 'wp-user-avatar'),
        'TR09' => __('Aydın', 'wp-user-avatar'),
        'TR10' => __('Balıkesir', 'wp-user-avatar'),
        'TR11' => __('Bilecik', 'wp-user-avatar'),
        'TR12' => __('Bingöl', 'wp-user-avatar'),
        'TR13' => __('Bitlis', 'wp-user-avatar'),
        'TR14' => __('Bolu', 'wp-user-avatar'),
        'TR15' => __('Burdur', 'wp-user-avatar'),
        'TR16' => __('Bursa', 'wp-user-avatar'),
        'TR17' => __('Çanakkale', 'wp-user-avatar'),
        'TR18' => __('Çankırı', 'wp-user-avatar'),
        'TR19' => __('Çorum', 'wp-user-avatar'),
        'TR20' => __('Denizli', 'wp-user-avatar'),
        'TR21' => __('Diyarbakır', 'wp-user-avatar'),
        'TR22' => __('Edirne', 'wp-user-avatar'),
        'TR23' => __('Elazığ', 'wp-user-avatar'),
        'TR24' => __('Erzincan', 'wp-user-avatar'),
        'TR25' => __('Erzurum', 'wp-user-avatar'),
        'TR26' => __('Eskişehir', 'wp-user-avatar'),
        'TR27' => __('Gaziantep', 'wp-user-avatar'),
        'TR28' => __('Giresun', 'wp-user-avatar'),
        'TR29' => __('Gümüşhane', 'wp-user-avatar'),
        'TR30' => __('Hakkari', 'wp-user-avatar'),
        'TR31' => __('Hatay', 'wp-user-avatar'),
        'TR32' => __('Isparta', 'wp-user-avatar'),
        'TR33' => __('İçel', 'wp-user-avatar'),
        'TR34' => __('İstanbul', 'wp-user-avatar'),
        'TR35' => __('İzmir', 'wp-user-avatar'),
        'TR36' => __('Kars', 'wp-user-avatar'),
        'TR37' => __('Kastamonu', 'wp-user-avatar'),
        'TR38' => __('Kayseri', 'wp-user-avatar'),
        'TR39' => __('Kırklareli', 'wp-user-avatar'),
        'TR40' => __('Kırşehir', 'wp-user-avatar'),
        'TR41' => __('Kocaeli', 'wp-user-avatar'),
        'TR42' => __('Konya', 'wp-user-avatar'),
        'TR43' => __('Kütahya', 'wp-user-avatar'),
        'TR44' => __('Malatya', 'wp-user-avatar'),
        'TR45' => __('Manisa', 'wp-user-avatar'),
        'TR46' => __('Kahramanmaraş', 'wp-user-avatar'),
        'TR47' => __('Mardin', 'wp-user-avatar'),
        'TR48' => __('Muğla', 'wp-user-avatar'),
        'TR49' => __('Muş', 'wp-user-avatar'),
        'TR50' => __('Nevşehir', 'wp-user-avatar'),
        'TR51' => __('Niğde', 'wp-user-avatar'),
        'TR52' => __('Ordu', 'wp-user-avatar'),
        'TR53' => __('Rize', 'wp-user-avatar'),
        'TR54' => __('Sakarya', 'wp-user-avatar'),
        'TR55' => __('Samsun', 'wp-user-avatar'),
        'TR56' => __('Siirt', 'wp-user-avatar'),
        'TR57' => __('Sinop', 'wp-user-avatar'),
        'TR58' => __('Sivas', 'wp-user-avatar'),
        'TR59' => __('Tekirdağ', 'wp-user-avatar'),
        'TR60' => __('Tokat', 'wp-user-avatar'),
        'TR61' => __('Trabzon', 'wp-user-avatar'),
        'TR62' => __('Tunceli', 'wp-user-avatar'),
        'TR63' => __('Şanlıurfa', 'wp-user-avatar'),
        'TR64' => __('Uşak', 'wp-user-avatar'),
        'TR65' => __('Van', 'wp-user-avatar'),
        'TR66' => __('Yozgat', 'wp-user-avatar'),
        'TR67' => __('Zonguldak', 'wp-user-avatar'),
        'TR68' => __('Aksaray', 'wp-user-avatar'),
        'TR69' => __('Bayburt', 'wp-user-avatar'),
        'TR70' => __('Karaman', 'wp-user-avatar'),
        'TR71' => __('Kırıkkale', 'wp-user-avatar'),
        'TR72' => __('Batman', 'wp-user-avatar'),
        'TR73' => __('Şırnak', 'wp-user-avatar'),
        'TR74' => __('Bartın', 'wp-user-avatar'),
        'TR75' => __('Ardahan', 'wp-user-avatar'),
        'TR76' => __('Iğdır', 'wp-user-avatar'),
        'TR77' => __('Yalova', 'wp-user-avatar'),
        'TR78' => __('Karabük', 'wp-user-avatar'),
        'TR79' => __('Kilis', 'wp-user-avatar'),
        'TR80' => __('Osmaniye', 'wp-user-avatar'),
        'TR81' => __('Düzce', 'wp-user-avatar'),
    ),
    'TZ' => array( // Tanzanian states.
        'TZ01' => __('Arusha', 'wp-user-avatar'),
        'TZ02' => __('Dar es Salaam', 'wp-user-avatar'),
        'TZ03' => __('Dodoma', 'wp-user-avatar'),
        'TZ04' => __('Iringa', 'wp-user-avatar'),
        'TZ05' => __('Kagera', 'wp-user-avatar'),
        'TZ06' => __('Pemba North', 'wp-user-avatar'),
        'TZ07' => __('Zanzibar North', 'wp-user-avatar'),
        'TZ08' => __('Kigoma', 'wp-user-avatar'),
        'TZ09' => __('Kilimanjaro', 'wp-user-avatar'),
        'TZ10' => __('Pemba South', 'wp-user-avatar'),
        'TZ11' => __('Zanzibar South', 'wp-user-avatar'),
        'TZ12' => __('Lindi', 'wp-user-avatar'),
        'TZ13' => __('Mara', 'wp-user-avatar'),
        'TZ14' => __('Mbeya', 'wp-user-avatar'),
        'TZ15' => __('Zanzibar West', 'wp-user-avatar'),
        'TZ16' => __('Morogoro', 'wp-user-avatar'),
        'TZ17' => __('Mtwara', 'wp-user-avatar'),
        'TZ18' => __('Mwanza', 'wp-user-avatar'),
        'TZ19' => __('Coast', 'wp-user-avatar'),
        'TZ20' => __('Rukwa', 'wp-user-avatar'),
        'TZ21' => __('Ruvuma', 'wp-user-avatar'),
        'TZ22' => __('Shinyanga', 'wp-user-avatar'),
        'TZ23' => __('Singida', 'wp-user-avatar'),
        'TZ24' => __('Tabora', 'wp-user-avatar'),
        'TZ25' => __('Tanga', 'wp-user-avatar'),
        'TZ26' => __('Manyara', 'wp-user-avatar'),
        'TZ27' => __('Geita', 'wp-user-avatar'),
        'TZ28' => __('Katavi', 'wp-user-avatar'),
        'TZ29' => __('Njombe', 'wp-user-avatar'),
        'TZ30' => __('Simiyu', 'wp-user-avatar'),
    ),
    'LK' => array(),
    'RS' => array( // Serbian districts.
        'RS00' => _x('Belgrade', 'district', 'wp-user-avatar'),
        'RS14' => _x('Bor', 'district', 'wp-user-avatar'),
        'RS11' => _x('Braničevo', 'district', 'wp-user-avatar'),
        'RS02' => _x('Central Banat', 'district', 'wp-user-avatar'),
        'RS10' => _x('Danube', 'district', 'wp-user-avatar'),
        'RS23' => _x('Jablanica', 'district', 'wp-user-avatar'),
        'RS09' => _x('Kolubara', 'district', 'wp-user-avatar'),
        'RS08' => _x('Mačva', 'district', 'wp-user-avatar'),
        'RS17' => _x('Morava', 'district', 'wp-user-avatar'),
        'RS20' => _x('Nišava', 'district', 'wp-user-avatar'),
        'RS01' => _x('North Bačka', 'district', 'wp-user-avatar'),
        'RS03' => _x('North Banat', 'district', 'wp-user-avatar'),
        'RS24' => _x('Pčinja', 'district', 'wp-user-avatar'),
        'RS22' => _x('Pirot', 'district', 'wp-user-avatar'),
        'RS13' => _x('Pomoravlje', 'district', 'wp-user-avatar'),
        'RS19' => _x('Rasina', 'district', 'wp-user-avatar'),
        'RS18' => _x('Raška', 'district', 'wp-user-avatar'),
        'RS06' => _x('South Bačka', 'district', 'wp-user-avatar'),
        'RS04' => _x('South Banat', 'district', 'wp-user-avatar'),
        'RS07' => _x('Srem', 'district', 'wp-user-avatar'),
        'RS12' => _x('Šumadija', 'district', 'wp-user-avatar'),
        'RS21' => _x('Toplica', 'district', 'wp-user-avatar'),
        'RS05' => _x('West Bačka', 'district', 'wp-user-avatar'),
        'RS15' => _x('Zaječar', 'district', 'wp-user-avatar'),
        'RS16' => _x('Zlatibor', 'district', 'wp-user-avatar'),
        'RS25' => _x('Kosovo', 'district', 'wp-user-avatar'),
        'RS26' => _x('Peć', 'district', 'wp-user-avatar'),
        'RS27' => _x('Prizren', 'district', 'wp-user-avatar'),
        'RS28' => _x('Kosovska Mitrovica', 'district', 'wp-user-avatar'),
        'RS29' => _x('Kosovo-Pomoravlje', 'district', 'wp-user-avatar'),
        'RSKM' => _x('Kosovo-Metohija', 'district', 'wp-user-avatar'),
        'RSVO' => _x('Vojvodina', 'district', 'wp-user-avatar'),
    ),
    'RW' => array(),
    'SE' => array(),
    'UA' => array( // Ukrainian oblasts. https://github.com/unicode-org/cldr/blob/release-42/common/subdivisions/en.xml#L5243.
        'UA05' => __('Vinnychchyna', 'wp-user-avatar'),
        'UA07' => __('Volyn', 'wp-user-avatar'),
        'UA09' => __('Luhanshchyna', 'wp-user-avatar'),
        'UA12' => __('Dnipropetrovshchyna', 'wp-user-avatar'),
        'UA14' => __('Donechchyna', 'wp-user-avatar'),
        'UA18' => __('Zhytomyrshchyna', 'wp-user-avatar'),
        'UA21' => __('Zakarpattia', 'wp-user-avatar'),
        'UA23' => __('Zaporizhzhya', 'wp-user-avatar'),
        'UA26' => __('Prykarpattia', 'wp-user-avatar'),
        'UA30' => __('Kyiv', 'wp-user-avatar'),
        'UA32' => __('Kyivshchyna', 'wp-user-avatar'),
        'UA35' => __('Kirovohradschyna', 'wp-user-avatar'),
        'UA40' => __('Sevastopol', 'wp-user-avatar'),
        'UA43' => __('Crimea', 'wp-user-avatar'),
        'UA46' => __('Lvivshchyna', 'wp-user-avatar'),
        'UA48' => __('Mykolayivschyna', 'wp-user-avatar'),
        'UA51' => __('Odeshchyna', 'wp-user-avatar'),
        'UA53' => __('Poltavshchyna', 'wp-user-avatar'),
        'UA56' => __('Rivnenshchyna', 'wp-user-avatar'),
        'UA59' => __('Sumshchyna', 'wp-user-avatar'),
        'UA61' => __('Ternopilshchyna', 'wp-user-avatar'),
        'UA63' => __('Kharkivshchyna', 'wp-user-avatar'),
        'UA65' => __('Khersonshchyna', 'wp-user-avatar'),
        'UA68' => __('Khmelnychchyna', 'wp-user-avatar'),
        'UA71' => __('Cherkashchyna', 'wp-user-avatar'),
        'UA74' => __('Chernihivshchyna', 'wp-user-avatar'),
        'UA77' => __('Chernivtsi Oblast', 'wp-user-avatar'),
    ),
    'UG' => array( // Ugandan districts.
        'UG314' => __('Abim', 'wp-user-avatar'),
        'UG301' => __('Adjumani', 'wp-user-avatar'),
        'UG322' => __('Agago', 'wp-user-avatar'),
        'UG323' => __('Alebtong', 'wp-user-avatar'),
        'UG315' => __('Amolatar', 'wp-user-avatar'),
        'UG324' => __('Amudat', 'wp-user-avatar'),
        'UG216' => __('Amuria', 'wp-user-avatar'),
        'UG316' => __('Amuru', 'wp-user-avatar'),
        'UG302' => __('Apac', 'wp-user-avatar'),
        'UG303' => __('Arua', 'wp-user-avatar'),
        'UG217' => __('Budaka', 'wp-user-avatar'),
        'UG218' => __('Bududa', 'wp-user-avatar'),
        'UG201' => __('Bugiri', 'wp-user-avatar'),
        'UG235' => __('Bugweri', 'wp-user-avatar'),
        'UG420' => __('Buhweju', 'wp-user-avatar'),
        'UG117' => __('Buikwe', 'wp-user-avatar'),
        'UG219' => __('Bukedea', 'wp-user-avatar'),
        'UG118' => __('Bukomansimbi', 'wp-user-avatar'),
        'UG220' => __('Bukwa', 'wp-user-avatar'),
        'UG225' => __('Bulambuli', 'wp-user-avatar'),
        'UG416' => __('Buliisa', 'wp-user-avatar'),
        'UG401' => __('Bundibugyo', 'wp-user-avatar'),
        'UG430' => __('Bunyangabu', 'wp-user-avatar'),
        'UG402' => __('Bushenyi', 'wp-user-avatar'),
        'UG202' => __('Busia', 'wp-user-avatar'),
        'UG221' => __('Butaleja', 'wp-user-avatar'),
        'UG119' => __('Butambala', 'wp-user-avatar'),
        'UG233' => __('Butebo', 'wp-user-avatar'),
        'UG120' => __('Buvuma', 'wp-user-avatar'),
        'UG226' => __('Buyende', 'wp-user-avatar'),
        'UG317' => __('Dokolo', 'wp-user-avatar'),
        'UG121' => __('Gomba', 'wp-user-avatar'),
        'UG304' => __('Gulu', 'wp-user-avatar'),
        'UG403' => __('Hoima', 'wp-user-avatar'),
        'UG417' => __('Ibanda', 'wp-user-avatar'),
        'UG203' => __('Iganga', 'wp-user-avatar'),
        'UG418' => __('Isingiro', 'wp-user-avatar'),
        'UG204' => __('Jinja', 'wp-user-avatar'),
        'UG318' => __('Kaabong', 'wp-user-avatar'),
        'UG404' => __('Kabale', 'wp-user-avatar'),
        'UG405' => __('Kabarole', 'wp-user-avatar'),
        'UG213' => __('Kaberamaido', 'wp-user-avatar'),
        'UG427' => __('Kagadi', 'wp-user-avatar'),
        'UG428' => __('Kakumiro', 'wp-user-avatar'),
        'UG101' => __('Kalangala', 'wp-user-avatar'),
        'UG222' => __('Kaliro', 'wp-user-avatar'),
        'UG122' => __('Kalungu', 'wp-user-avatar'),
        'UG102' => __('Kampala', 'wp-user-avatar'),
        'UG205' => __('Kamuli', 'wp-user-avatar'),
        'UG413' => __('Kamwenge', 'wp-user-avatar'),
        'UG414' => __('Kanungu', 'wp-user-avatar'),
        'UG206' => __('Kapchorwa', 'wp-user-avatar'),
        'UG236' => __('Kapelebyong', 'wp-user-avatar'),
        'UG126' => __('Kasanda', 'wp-user-avatar'),
        'UG406' => __('Kasese', 'wp-user-avatar'),
        'UG207' => __('Katakwi', 'wp-user-avatar'),
        'UG112' => __('Kayunga', 'wp-user-avatar'),
        'UG407' => __('Kibaale', 'wp-user-avatar'),
        'UG103' => __('Kiboga', 'wp-user-avatar'),
        'UG227' => __('Kibuku', 'wp-user-avatar'),
        'UG432' => __('Kikuube', 'wp-user-avatar'),
        'UG419' => __('Kiruhura', 'wp-user-avatar'),
        'UG421' => __('Kiryandongo', 'wp-user-avatar'),
        'UG408' => __('Kisoro', 'wp-user-avatar'),
        'UG305' => __('Kitgum', 'wp-user-avatar'),
        'UG319' => __('Koboko', 'wp-user-avatar'),
        'UG325' => __('Kole', 'wp-user-avatar'),
        'UG306' => __('Kotido', 'wp-user-avatar'),
        'UG208' => __('Kumi', 'wp-user-avatar'),
        'UG333' => __('Kwania', 'wp-user-avatar'),
        'UG228' => __('Kween', 'wp-user-avatar'),
        'UG123' => __('Kyankwanzi', 'wp-user-avatar'),
        'UG422' => __('Kyegegwa', 'wp-user-avatar'),
        'UG415' => __('Kyenjojo', 'wp-user-avatar'),
        'UG125' => __('Kyotera', 'wp-user-avatar'),
        'UG326' => __('Lamwo', 'wp-user-avatar'),
        'UG307' => __('Lira', 'wp-user-avatar'),
        'UG229' => __('Luuka', 'wp-user-avatar'),
        'UG104' => __('Luwero', 'wp-user-avatar'),
        'UG124' => __('Lwengo', 'wp-user-avatar'),
        'UG114' => __('Lyantonde', 'wp-user-avatar'),
        'UG223' => __('Manafwa', 'wp-user-avatar'),
        'UG320' => __('Maracha', 'wp-user-avatar'),
        'UG105' => __('Masaka', 'wp-user-avatar'),
        'UG409' => __('Masindi', 'wp-user-avatar'),
        'UG214' => __('Mayuge', 'wp-user-avatar'),
        'UG209' => __('Mbale', 'wp-user-avatar'),
        'UG410' => __('Mbarara', 'wp-user-avatar'),
        'UG423' => __('Mitooma', 'wp-user-avatar'),
        'UG115' => __('Mityana', 'wp-user-avatar'),
        'UG308' => __('Moroto', 'wp-user-avatar'),
        'UG309' => __('Moyo', 'wp-user-avatar'),
        'UG106' => __('Mpigi', 'wp-user-avatar'),
        'UG107' => __('Mubende', 'wp-user-avatar'),
        'UG108' => __('Mukono', 'wp-user-avatar'),
        'UG334' => __('Nabilatuk', 'wp-user-avatar'),
        'UG311' => __('Nakapiripirit', 'wp-user-avatar'),
        'UG116' => __('Nakaseke', 'wp-user-avatar'),
        'UG109' => __('Nakasongola', 'wp-user-avatar'),
        'UG230' => __('Namayingo', 'wp-user-avatar'),
        'UG234' => __('Namisindwa', 'wp-user-avatar'),
        'UG224' => __('Namutumba', 'wp-user-avatar'),
        'UG327' => __('Napak', 'wp-user-avatar'),
        'UG310' => __('Nebbi', 'wp-user-avatar'),
        'UG231' => __('Ngora', 'wp-user-avatar'),
        'UG424' => __('Ntoroko', 'wp-user-avatar'),
        'UG411' => __('Ntungamo', 'wp-user-avatar'),
        'UG328' => __('Nwoya', 'wp-user-avatar'),
        'UG331' => __('Omoro', 'wp-user-avatar'),
        'UG329' => __('Otuke', 'wp-user-avatar'),
        'UG321' => __('Oyam', 'wp-user-avatar'),
        'UG312' => __('Pader', 'wp-user-avatar'),
        'UG332' => __('Pakwach', 'wp-user-avatar'),
        'UG210' => __('Pallisa', 'wp-user-avatar'),
        'UG110' => __('Rakai', 'wp-user-avatar'),
        'UG429' => __('Rubanda', 'wp-user-avatar'),
        'UG425' => __('Rubirizi', 'wp-user-avatar'),
        'UG431' => __('Rukiga', 'wp-user-avatar'),
        'UG412' => __('Rukungiri', 'wp-user-avatar'),
        'UG111' => __('Sembabule', 'wp-user-avatar'),
        'UG232' => __('Serere', 'wp-user-avatar'),
        'UG426' => __('Sheema', 'wp-user-avatar'),
        'UG215' => __('Sironko', 'wp-user-avatar'),
        'UG211' => __('Soroti', 'wp-user-avatar'),
        'UG212' => __('Tororo', 'wp-user-avatar'),
        'UG113' => __('Wakiso', 'wp-user-avatar'),
        'UG313' => __('Yumbe', 'wp-user-avatar'),
        'UG330' => __('Zombo', 'wp-user-avatar'),
    ),
    'UM' => array(
        '81' => __('Baker Island', 'wp-user-avatar'),
        '84' => __('Howland Island', 'wp-user-avatar'),
        '86' => __('Jarvis Island', 'wp-user-avatar'),
        '67' => __('Johnston Atoll', 'wp-user-avatar'),
        '89' => __('Kingman Reef', 'wp-user-avatar'),
        '71' => __('Midway Atoll', 'wp-user-avatar'),
        '76' => __('Navassa Island', 'wp-user-avatar'),
        '95' => __('Palmyra Atoll', 'wp-user-avatar'),
        '79' => __('Wake Island', 'wp-user-avatar'),
    ),
    'US' => array( // U.S. states.
        'AL' => __('Alabama', 'wp-user-avatar'),
        'AK' => __('Alaska', 'wp-user-avatar'),
        'AZ' => __('Arizona', 'wp-user-avatar'),
        'AR' => __('Arkansas', 'wp-user-avatar'),
        'CA' => __('California', 'wp-user-avatar'),
        'CO' => __('Colorado', 'wp-user-avatar'),
        'CT' => __('Connecticut', 'wp-user-avatar'),
        'DE' => __('Delaware', 'wp-user-avatar'),
        'DC' => __('District Of Columbia', 'wp-user-avatar'),
        'FL' => __('Florida', 'wp-user-avatar'),
        'GA' => _x('Georgia', 'US state of Georgia', 'wp-user-avatar'),
        'HI' => __('Hawaii', 'wp-user-avatar'),
        'ID' => __('Idaho', 'wp-user-avatar'),
        'IL' => __('Illinois', 'wp-user-avatar'),
        'IN' => __('Indiana', 'wp-user-avatar'),
        'IA' => __('Iowa', 'wp-user-avatar'),
        'KS' => __('Kansas', 'wp-user-avatar'),
        'KY' => __('Kentucky', 'wp-user-avatar'),
        'LA' => __('Louisiana', 'wp-user-avatar'),
        'ME' => __('Maine', 'wp-user-avatar'),
        'MD' => __('Maryland', 'wp-user-avatar'),
        'MA' => __('Massachusetts', 'wp-user-avatar'),
        'MI' => __('Michigan', 'wp-user-avatar'),
        'MN' => __('Minnesota', 'wp-user-avatar'),
        'MS' => __('Mississippi', 'wp-user-avatar'),
        'MO' => __('Missouri', 'wp-user-avatar'),
        'MT' => __('Montana', 'wp-user-avatar'),
        'NE' => __('Nebraska', 'wp-user-avatar'),
        'NV' => __('Nevada', 'wp-user-avatar'),
        'NH' => __('New Hampshire', 'wp-user-avatar'),
        'NJ' => __('New Jersey', 'wp-user-avatar'),
        'NM' => __('New Mexico', 'wp-user-avatar'),
        'NY' => __('New York', 'wp-user-avatar'),
        'NC' => __('North Carolina', 'wp-user-avatar'),
        'ND' => __('North Dakota', 'wp-user-avatar'),
        'OH' => __('Ohio', 'wp-user-avatar'),
        'OK' => __('Oklahoma', 'wp-user-avatar'),
        'OR' => __('Oregon', 'wp-user-avatar'),
        'PA' => __('Pennsylvania', 'wp-user-avatar'),
        'RI' => __('Rhode Island', 'wp-user-avatar'),
        'SC' => __('South Carolina', 'wp-user-avatar'),
        'SD' => __('South Dakota', 'wp-user-avatar'),
        'TN' => __('Tennessee', 'wp-user-avatar'),
        'TX' => __('Texas', 'wp-user-avatar'),
        'UT' => __('Utah', 'wp-user-avatar'),
        'VT' => __('Vermont', 'wp-user-avatar'),
        'VA' => __('Virginia', 'wp-user-avatar'),
        'WA' => __('Washington', 'wp-user-avatar'),
        'WV' => __('West Virginia', 'wp-user-avatar'),
        'WI' => __('Wisconsin', 'wp-user-avatar'),
        'WY' => __('Wyoming', 'wp-user-avatar'),
        'AS' => __('American Samoa', 'wp-user-avatar'),
        'AA' => __('Armed Forces (AA)', 'wp-user-avatar'),
        'AE' => __('Armed Forces (AE)', 'wp-user-avatar'),
        'AP' => __('Armed Forces (AP)', 'wp-user-avatar'),
        'PW' => __('Palau', 'wp-user-avatar'),
        'PR' => __('Puerto Rico', 'wp-user-avatar'),
    ),
    'UY' => array( // Uruguayan states.
        'UY-AR' => __('Artigas', 'wp-user-avatar'),
        'UY-CA' => __('Canelones', 'wp-user-avatar'),
        'UY-CL' => __('Cerro Largo', 'wp-user-avatar'),
        'UY-CO' => __('Colonia', 'wp-user-avatar'),
        'UY-DU' => __('Durazno', 'wp-user-avatar'),
        'UY-FS' => __('Flores', 'wp-user-avatar'),
        'UY-FD' => __('Florida', 'wp-user-avatar'),
        'UY-LA' => __('Lavalleja', 'wp-user-avatar'),
        'UY-MA' => __('Maldonado', 'wp-user-avatar'),
        'UY-MO' => __('Montevideo', 'wp-user-avatar'),
        'UY-PA' => __('Paysandú', 'wp-user-avatar'),
        'UY-RN' => __('Río Negro', 'wp-user-avatar'),
        'UY-RV' => __('Rivera', 'wp-user-avatar'),
        'UY-RO' => __('Rocha', 'wp-user-avatar'),
        'UY-SA' => __('Salto', 'wp-user-avatar'),
        'UY-SJ' => __('San José', 'wp-user-avatar'),
        'UY-SO' => __('Soriano', 'wp-user-avatar'),
        'UY-TA' => __('Tacuarembó', 'wp-user-avatar'),
        'UY-TT' => __('Treinta y Tres', 'wp-user-avatar'),
    ),
    'VE' => array( // Venezuelan states.
        'VE-A' => __('Capital', 'wp-user-avatar'),
        'VE-B' => __('Anzoátegui', 'wp-user-avatar'),
        'VE-C' => __('Apure', 'wp-user-avatar'),
        'VE-D' => __('Aragua', 'wp-user-avatar'),
        'VE-E' => __('Barinas', 'wp-user-avatar'),
        'VE-F' => __('Bolívar', 'wp-user-avatar'),
        'VE-G' => __('Carabobo', 'wp-user-avatar'),
        'VE-H' => __('Cojedes', 'wp-user-avatar'),
        'VE-I' => __('Falcón', 'wp-user-avatar'),
        'VE-J' => __('Guárico', 'wp-user-avatar'),
        'VE-K' => __('Lara', 'wp-user-avatar'),
        'VE-L' => __('Mérida', 'wp-user-avatar'),
        'VE-M' => __('Miranda', 'wp-user-avatar'),
        'VE-N' => __('Monagas', 'wp-user-avatar'),
        'VE-O' => __('Nueva Esparta', 'wp-user-avatar'),
        'VE-P' => __('Portuguesa', 'wp-user-avatar'),
        'VE-R' => __('Sucre', 'wp-user-avatar'),
        'VE-S' => __('Táchira', 'wp-user-avatar'),
        'VE-T' => __('Trujillo', 'wp-user-avatar'),
        'VE-U' => __('Yaracuy', 'wp-user-avatar'),
        'VE-V' => __('Zulia', 'wp-user-avatar'),
        'VE-W' => __('Federal Dependencies', 'wp-user-avatar'),
        'VE-X' => __('La Guaira (Vargas)', 'wp-user-avatar'),
        'VE-Y' => __('Delta Amacuro', 'wp-user-avatar'),
        'VE-Z' => __('Amazonas', 'wp-user-avatar'),
    ),
    'VN' => array(),
    'YT' => array(),
    'ZA' => array( // South African states.
        'EC'  => __('Eastern Cape', 'wp-user-avatar'),
        'FS'  => __('Free State', 'wp-user-avatar'),
        'GP'  => __('Gauteng', 'wp-user-avatar'),
        'KZN' => __('KwaZulu-Natal', 'wp-user-avatar'),
        'LP'  => __('Limpopo', 'wp-user-avatar'),
        'MP'  => __('Mpumalanga', 'wp-user-avatar'),
        'NC'  => __('Northern Cape', 'wp-user-avatar'),
        'NW'  => __('North West', 'wp-user-avatar'),
        'WC'  => __('Western Cape', 'wp-user-avatar'),
    ),
    'ZM' => array( // Zambian provinces.
        'ZM-01' => __('Western', 'wp-user-avatar'),
        'ZM-02' => __('Central', 'wp-user-avatar'),
        'ZM-03' => __('Eastern', 'wp-user-avatar'),
        'ZM-04' => __('Luapula', 'wp-user-avatar'),
        'ZM-05' => __('Northern', 'wp-user-avatar'),
        'ZM-06' => __('North-Western', 'wp-user-avatar'),
        'ZM-07' => __('Southern', 'wp-user-avatar'),
        'ZM-08' => __('Copperbelt', 'wp-user-avatar'),
        'ZM-09' => __('Lusaka', 'wp-user-avatar'),
        'ZM-10' => __('Muchinga', 'wp-user-avatar'),
    ),
);